package com.pangding.web.authority.service.code;

import com.pangding.web.vo.system.pd.code.CodeModelVo;
import com.pangding.web.vo.system.req.code.CodeModelReqVo;
import com.pangding.web.vo.system.res.code.CodeModelResVo;
import com.yanzuoguang.util.vo.PageSizeData;

import java.util.List;

public interface CodeModelService {

    /**
     * 查询码模板列表（分页）
     * @param req
     * @return
     */
    PageSizeData<CodeModelResVo> queryCodeModelPageList(CodeModelReqVo req);


    /**
     * 查询码模板列表（不分页）
     * @param req
     * @return
     */
    List<CodeModelResVo> queryCodeModelList(CodeModelReqVo req);

    /**
     * 查询码模板列表（不分页 包含扩展信息）
     * @param req
     * @return
     */
    List<CodeModelResVo> queryList(CodeModelReqVo req);

    /**
     * 查询码模板详情
     * @param req
     * @return
     */
    CodeModelResVo queryCodeModel(CodeModelReqVo req);

    /**
     * 保存码模板信息
     * @param req
     * @return
     */
    CodeModelVo saveCodeModel(CodeModelReqVo req);

    /**
     * 删除模板信息
     * @param req
     */
    void removeCodeModel(CodeModelReqVo req);

}
