package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CompanyAgreementDao;
import com.pangding.web.vo.system.pd.company.CompanyAgreementVo;
import com.pangding.web.vo.system.req.company.CompanyAgreementReqVo;
import com.pangding.web.vo.system.req.company.CompanyReqVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

@Component
public class CompanyAgreementDaoImpl extends BaseDaoImpl implements CompanyAgreementDao {

    private static final String QUERY_LIST = "QUERY_LIST";

    @Override
    protected void init() {
        register(CompanyAgreementVo.class);

        table.add(QUERY_LIST,"select * " +
                " from pd_company_agreement " +
                "where 1=1 {WHERE} order by create_time desc")
                .add("companyId"," and company_id = ? ");
    }


    @Override
    public PageSizeData<CompanyAgreementVo> findCompanyAgreement(CompanyAgreementReqVo reqVo) {
        return this.queryPage(CompanyAgreementVo.class,reqVo,QUERY_LIST,reqVo);
    }




}
