package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.UserRoleDao;
import com.pangding.web.authority.vo.reqvo.UserRoleGetReqVo;
import com.pangding.web.authority.vo.UserRoleVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhangjinyao
 */
@Component
public class UserRoleDaoImpl extends BaseDaoImpl implements UserRoleDao {

    private static final String GET_USER_ROLE_LIST = "GET_USER_ROLE_LIST";

    @Override
    protected void init() {

        register(UserRoleVo.class);

        table.add(GET_USER_ROLE_LIST,"select * from pd_user_role where 1=1 ")
                .add("userId","and user_id = ?")
                .add("roleId","and role_id = ?");

    }

    @Override
    public List<UserRoleVo> getUserRoleList(UserRoleGetReqVo reqVo) {
        return this.query(UserRoleVo.class,GET_USER_ROLE_LIST,reqVo);
    }

}
