package com.pangding.web.authority.dao;

import com.pangding.web.authority.vo.AuthorityVo;
import com.pangding.web.authority.vo.reqvo.AuthorityListReqVo;
import com.pangding.web.authority.vo.reqvo.ListAuthorityByPageReqVo;
import com.yanzuoguang.dao.BaseDao;
import com.yanzuoguang.util.vo.PageSizeData;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface AuthorityDao extends BaseDao {

    /**
     * 检查新建或修改的authorityVo对象是否合法
     *
     * @param authorityVo authorityVo对象
     */
    void checkValid(AuthorityVo authorityVo);

    /**
     * 获取权限分页对象
     *
     * @param reqVo
     * @return 权限分页对象
     */
    PageSizeData<AuthorityVo> getAuthorityList(ListAuthorityByPageReqVo reqVo);

    List<AuthorityVo> getLevelOne(AuthorityListReqVo reqVo);

}
