package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.RoleDao;
import com.pangding.web.authority.vo.reqvo.ListRoleReqVo;
import com.pangding.web.authority.vo.reqvo.RoleGetReqVo;
import com.pangding.web.authority.vo.RoleVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhangjinyao
 */
@Component
public class RoleDaoImpl extends BaseDaoImpl implements RoleDao {


    private static final String CHECK_NAME_EXIST = "CHECK_NAME_EXIST";
    private static final String SELECT = "SELECT";

    @Override
    protected void init() {
        register(RoleVo.class);

        table.addExist(CHECK_NAME_EXIST,"name");

        table.add(SELECT,"select * from pd_role where 1=1 ")
        .add("id","and pid = ?");

    }

    @Override
    public RoleVo getRoleById(RoleGetReqVo roleGetReqVo) {
        return this.load(roleGetReqVo,RoleVo.class);
    }

    @Override
    public RoleVo getRoleByRoleName(RoleGetReqVo getRoleByRoleNameReqVo) {
        return this.load(getRoleByRoleNameReqVo, RoleVo.class);
    }

    @Override
    public void checkNameExist(RoleVo roleVo){
        this.checkExist(CHECK_NAME_EXIST,roleVo,"角色名已存在");
    }

    @Override
    public PageSizeData<RoleVo> getRoleVoList(ListRoleReqVo req) {

        return this.queryPage(RoleVo.class,req,SELECT,req);
    }

    @Override
    public List<RoleVo> getChild(RoleGetReqVo roleGetReqVo) {
        return this.query(RoleVo.class,SELECT, roleGetReqVo);
    }
}
