package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.feign.StoreFeign;
import com.pangding.web.authority.service.CompanyService;
import com.pangding.web.authority.service.VerifyCodeService;
import com.pangding.web.authority.util.*;
import com.pangding.web.authority.vo.*;
import com.pangding.web.authority.vo.cloudvo.LoginResVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.service.RegisterService;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.vo.resvo.LoginCompanyResVo;
import com.pangding.web.authority.vo.resvo.SaveCompanyResVo;
import com.pangding.web.util.RSAUtils;
import com.yanzuoguang.token.TokenHelper;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:23
 */

@Service
public class RegisterServiceImpl implements RegisterService {

    @Autowired
    CompanyDao companyDaoImpl;
    @Autowired
    UserDao userDaoImpl;
    @Autowired
    UserService userServiceImpl;
    @Autowired
    CompanyExtendDao companyExtendDaoImpl;
    @Autowired
    CompanyBankCardDao companyBankCardDaoImpl;
    @Autowired
    UserRoleDao userRoleDaoImpl;
    @Autowired
    private StoreFeign storeFeign;
    @Autowired
    private CompanyService companyService;
    @Autowired
    VerifyCodeService verifyCodeServiceImpl;
    @Autowired
    RoleAuthorityDao roleAuthorityDaoImpl;
    @Autowired
    AuthorityDao authorityDaoImpl;

    /**
     * 判断注册编码是否存在
     *
     * @param invitationCode 注册编码
     * @return 若不存在，返回null，存在则返回CompanyExtendVo对象
     */
    @Override
    public CompanyExtendVo checkInvitationCode(String invitationCode) {
        CompanyExtendGetReqVo reqVo = new CompanyExtendGetReqVo();
        reqVo.setInvitationCode(invitationCode);
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(reqVo,CompanyExtendVo.class);
        return companyExtendVo == null ? null : companyExtendVo;
    }

    /**
     * 保存用户信息，并返回公司信息
     *
     * @param registerUserReqVo
     * @return CompanyVo对象
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CompanyVo saveUser(RegisterUserReqVo registerUserReqVo) throws Exception {

        // 检查账户是否合法
        userServiceImpl.isValid(registerUserReqVo.getAccount());

        UserVo userVo = new UserVo();
        userVo.setAccount(registerUserReqVo.getAccount());
        // 检查用户名是否存在
        userServiceImpl.checkAccount(userVo);

        if (!StringHelper.compare( registerUserReqVo.getPassword(), registerUserReqVo.getConfirmPassword())){
            throw new CodeException("确认密码错误");
        }

        CompanyExtendVo companyExtendVo = checkInvitationCode(registerUserReqVo.getInvitationCode());
        if (null == companyExtendVo){
            throw new CodeException("注册编码错误");
        }

        /*通过私钥将rsa加密的密码解密*/
        String password = RSAUtils.decryptionByPrivateKey(registerUserReqVo.getPassword(), RsaConstant.privateKey);

        String companyId = StringHelper.getNewID();
        userVo.setPassword(StringHelper.md5(password));
        userVo.setId(StringHelper.getNewID());
        userVo.setRemark(password);
        userVo.setCompanyId(companyId);
        userDaoImpl.create(userVo);
        CompanyVo companyVo = new CompanyVo();
        companyVo.setId(companyId);
        companyVo.setInvitationCompanyId(companyExtendVo.getId());
        companyVo.setCompanyType(registerUserReqVo.getCompanyType());
        companyDaoImpl.create(companyVo);
        return companyVo;
    }

    /**
     * 检查电话号码是否已存在
     *
     * @param contactPhone 联系电话
     */
    @Override
    public void checkPhone(String id,String contactPhone) {
        CompanyVo companyVo = new CompanyVo();
        companyVo.setId(id);
        companyVo.setContactPhone(contactPhone);
        companyDaoImpl.checkPhone(companyVo);
    }

    /**
     * 保存个人注册的公司信息
     *
     * @param reqVo
     * @return 返回保存数据各表的主键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaveCompanyResVo saveIndividual(RegisterIndividualReqVo reqVo) {

        this.checkPhone(reqVo.getId(),reqVo.getContactPhone());

        /*更新公司表*/
        CompanyVo companyVo = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo,reqVo);
        companyVo.setProductOrInterface(CompanyConstant.PRODUCT);
        companyDaoImpl.update(companyVo);

        /*保存公司扩展表*/
        CompanyExtendVo extendVo = new CompanyExtendVo();
        extendVo.setId(reqVo.getId());
        companyExtendDaoImpl.save(extendVo);

        /*此处应该调用第三方接口传入companyVo发送手机验证码并更新公司状态*/

        /*跟新用户表添加联系方式*/
        UserVo userReqVo = new UserVo();
        userReqVo.setCompanyId(reqVo.getId());
        UserVo userVo = userDaoImpl.load(userReqVo,UserVo.class);
        userVo.setPhone(reqVo.getContactPhone());
        userDaoImpl.update(userVo);

        /*保存或更新商户表*/
        MerchantCreateReqVo req=new MerchantCreateReqVo();
        req.setId(StringHelper.getNewID());
        req.setName(reqVo.getCompanyName());
        req.setAddress(reqVo.getAddress());
        req.setType(reqVo.getCompanyAttribute());
        req.setProductCompanyId(reqVo.getId());
        req.setUserId(userVo.getId());
        req.setUsername(userVo.getAccount());
        req.setReqId(reqVo.getReqId());
        if (null == reqVo.getMerchantId() || "".equals(reqVo.getMerchantId())){
            req.setId(StringHelper.getNewID());
        }else {
            req.setId(reqVo.getMerchantId());
        }


        SaveCompanyResVo resVo = new SaveCompanyResVo();
        ResponseResult result = storeFeign.merchantCreate(req);
        if (result.getCode().equals("00")){
            String merchantId = (String) result.getData();
            resVo.setMerchantId(merchantId);
        }

        resVo.setCompanyId(companyVo.getId());
        resVo.setCompanyExtendId(extendVo.getId());
        resVo.setUserId(userVo.getId());

        return resVo;
    }

    /**
     * 保存企业注册的公司信息
     *
     * @param reqVo
     * @return 返回保存数据各表的主键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaveCompanyResVo saveEnterprice(RegisterEnterpriceReqVo reqVo) {

        this.checkPhone(reqVo.getId(),reqVo.getContactPhone());

        /*更新公司表*/
        CompanyVo companyVo = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo,reqVo);
        companyVo.setProductOrInterface(CompanyConstant.PRODUCT);
        companyDaoImpl.update(companyVo);

        /*保存公司扩展表*/
        CompanyExtendVo extendVo = new CompanyExtendVo();
        extendVo.setId(reqVo.getId());
        companyExtendDaoImpl.save(extendVo);

        SaveCompanyResVo resVo = new SaveCompanyResVo();

        /*此处应该调用第三方接口传入companyVo发送手机验证码并更新公司状态*/

        /*保存银行卡，并将其设置为默认银行卡*/
        CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
        ObjectHelper.writeWithFrom(companyBankCardVo,reqVo);
        companyBankCardVo.setId(StringHelper.getNewID());
        companyBankCardVo.setCompanyId(reqVo.getId());
        companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
        companyBankCardDaoImpl.save(companyBankCardVo);

        /*更新用户信息，保存联系方式*/
        UserVo userReqVo = new UserVo();
        userReqVo.setCompanyId(reqVo.getId());
        UserVo userVo = userDaoImpl.load(userReqVo,UserVo.class);
        userVo.setPhone(reqVo.getContactPhone());
        userDaoImpl.update(userVo);

        /*保存或更新商户表*/
        MerchantCreateReqVo req=new MerchantCreateReqVo();
        req.setReqId(StringHelper.getNewID());
        req.setId(StringHelper.getNewID());
        req.setName(reqVo.getCompanyName());
        req.setAddress(reqVo.getAddress());
        req.setType(reqVo.getCompanyAttribute());
        req.setProductCompanyId(reqVo.getId());
        req.setUserId(userVo.getId());
        req.setUsername(userVo.getAccount());
        if (null == reqVo.getMerchantId() || "".equals(reqVo.getMerchantId())){
            req.setId(StringHelper.getNewID());
        }else {
            req.setId(reqVo.getMerchantId());
        }

        ResponseResult result = storeFeign.merchantCreate(req);
        if (result.getCode().equals("00")){
            String merchantId = (String) result.getData();
            resVo.setMerchantId(merchantId);
        }

        resVo.setCompanyId(companyVo.getId());
        resVo.setCompanyBankCardId(companyBankCardVo.getId());
        resVo.setCompanyExtendId(extendVo.getId());
        resVo.setUserId(userVo.getId());

        return resVo;
    }

    /**
     * 登陆，验证用户名或手机号，密码是否正确
     * 返回token,account,LoginCompanyResVo对象（id：公司id,status：公司状态,companyAttribute：属性,bankCardCodeList：绑定的银行卡数组）
     *
     * @param reqVo
     * @return
     */
    @Override
    public LoginResVo login(LoginReqVo reqVo) throws Exception {
        String accountOrPhone = reqVo.getAccountOrPhone();
        UserVo userVo;
        if (userServiceImpl.isNumeric(accountOrPhone)){
            userVo = userServiceImpl.getUserByPhone(accountOrPhone);
        }else {
            userVo = userServiceImpl.getUserByAccount(accountOrPhone);
        }
        if (userVo == null){
            throw new CodeException("用户名或密码错误");
        }

        /*通过私钥将rsa加密的密码解密*/
        String password = RSAUtils.decryptionByPrivateKey(reqVo.getPassword(),RsaConstant.privateKey);
        if (!(StringHelper.md5(reqVo.getPassword()).equals(password))){
            throw new CodeException("用户名或密码错误");
        }
        String token = TokenUtil.createToken(reqVo.getAccountOrPhone());
        TokenHelper.write(token,reqVo);
        LoginResVo resVo = new LoginResVo();
        resVo.setToken(token);
        resVo.setAccount(userVo.getAccount());
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(userVo.getCompanyId());
        CompanyVo companyVo = companyDaoImpl.load(companyGetReqVo,CompanyVo.class);
        /*判断基本信息是否完善，及状态是否为2，且为个人用户，若不完善则跳转个人完善页面*/
        /*if (!companyVo.getStatus().equals(LoginConstant.FINISHED_BASIC_INFO) && CompanyConstant.COMPANY_TYPE_PERSON.equals(companyVo.getCompanyType())){
            resVo.setCode("01");
            return resVo;
        }*/
        /*判断基本信息是否完善，及状态是否为2，且为公司用户，若不完善则跳转个人完善页面*/
        /*else if (!companyVo.getStatus().equals(LoginConstant.FINISHED_BASIC_INFO) && CompanyConstant.COMPANY_TYPE_COMPANY.equals(companyVo.getCompanyType())){
            resVo.setCode("02");
            return resVo;
        }*/
        /*判断电子签约状态，若不为10，则跳转签约页面*/
        /*else if (!companyVo.getSigningStatus().equals(LoginConstant.HAVE_SIGNED)){
            resVo.setCode("04");
            return resVo;
        }*/
        LoginCompanyResVo loginCompanyResVo = new LoginCompanyResVo();
        loginCompanyResVo.setId(companyVo.getId());
        loginCompanyResVo.setStatus(companyVo.getStatus());
        loginCompanyResVo.setCompanyAttribute(companyVo.getCompanyAttribute());

        CompanyBankCardGetReqVo getReqVo = new CompanyBankCardGetReqVo();
        getReqVo.setCompanyId(companyVo.getId());
        List<CompanyBankCardVo> companyBankCardVoList = companyBankCardDaoImpl.loadList(getReqVo,CompanyBankCardVo.class);
        List<String> bankCardCodeList = new ArrayList();
        if (companyBankCardVoList != null && !companyBankCardVoList.isEmpty()){
            for (CompanyBankCardVo companyBankCardVo:companyBankCardVoList) {
                bankCardCodeList.add(companyBankCardVo.getBankCardCode());
            }
        }/*else{
            *//*该公司没有银行卡，需要跳转添加银行卡*//*
            resVo.setCode("03");
            return resVo;
        }*/
        /*获取用户权限列表*/
        UserRoleGetReqVo userRoleGetReqVo = new UserRoleGetReqVo();
        userRoleGetReqVo.setUserId(userVo.getId());
        List<UserRoleVo> userRoleVoList = userRoleDaoImpl.loadList(userRoleGetReqVo,UserRoleVo.class);
        if (null != userRoleVoList && !userRoleVoList.isEmpty()){
            List<String> roleIdList = new ArrayList();
            for (UserRoleVo userRoleVo:userRoleVoList) {
                roleIdList.add(userRoleVo.getRoleId());
            }
            List<String> authorityIdList = new ArrayList();
            for (String roleId:roleIdList) {
                RoleAuthorityGetReqVo roleAuthorityGetReqVo = new RoleAuthorityGetReqVo();
                roleAuthorityGetReqVo.setRoleId(roleId);
                List<RoleAuthorityVo> roleAuthorityVoList = roleAuthorityDaoImpl.loadList(roleAuthorityGetReqVo,RoleAuthorityVo.class);
                if (roleAuthorityVoList != null && !roleAuthorityVoList.isEmpty()){
                    List<String> authorityIds = new ArrayList();
                    for (RoleAuthorityVo roleAuthorityVo:roleAuthorityVoList) {
                        authorityIds.add(roleAuthorityVo.getAuthorityId());
                    }
                    authorityIdList.addAll(authorityIds);
                }
            }
            List<AuthorityVo> authorityVoList = new ArrayList();
            for (String authorityId:authorityIdList) {
                AuthorityGetReqVo authorityGetReqVo = new AuthorityGetReqVo();
                authorityGetReqVo.setId(authorityId);
                AuthorityVo authorityVo = authorityDaoImpl.load(authorityGetReqVo,AuthorityVo.class);
                authorityVoList.add(authorityVo);
            }
            resVo.setAuthorityVoList(authorityVoList);
        }
        loginCompanyResVo.setBankCardCodeList(bankCardCodeList);
        resVo.setCompanyResVo(loginCompanyResVo);
        return resVo;
    }

    @Override
    public LoginResVo verifyLogin(ComputerLoginReqVo reqVo, HttpSession session, HttpServletRequest request) throws Exception {
        verifyCodeServiceImpl.validImage(reqVo.getVerifyCode(),session,request);
        LoginReqVo reqVo1 = new LoginReqVo();
        ObjectHelper.writeWithFrom(reqVo1,reqVo);
        return this.login(reqVo1);
    }

    /**
     * 将通过公司id获取到的公司信息和验证码传到第三方，并将返回的信息用于更新公司状态
     * @param reqVo 封装了公司id和验证码的请求对象
     * @return
     */
    @Override
    public String individualSubmit(IndividualSubmitReqVo reqVo) {
        CompanyGetReqVo getReqVo = new CompanyGetReqVo();
        getReqVo.setId(reqVo.getId());
        CompanyVo companyVo = companyDaoImpl.load(getReqVo,CompanyVo.class);
        String verifyCode = reqVo.getVerifyCode();
        /*此处应该将companyVo和verifyCode发送到第三方接口，返回的数据用于更新公司信息*/
        return reqVo.getVerifyCode();
    }

    /**
     * 将通过公司id获取到的公司信息和验证码传到第三方，并将返回的信息用于更新公司状态
     * @param reqVo 封装了公司id和验证码的请求对象
     * @return
     */
    @Override
    public String enterpriceSubmit(EnterpriceSubmitReqVo reqVo) {
        CompanyGetReqVo getReqVo = new CompanyGetReqVo();
        getReqVo.setId(reqVo.getId());
        CompanyVo companyVo = companyDaoImpl.load(getReqVo,CompanyVo.class);
        String verifyCode = reqVo.getVerifyCode();
        /*此处应该将companyVo和verifyCode发送到第三方接口，返回的数据用于更新公司信息*/
        return reqVo.getVerifyCode();
    }
}
