package com.pangding.web.tright.controller;


import com.pangding.web.tright.currency.Result;
import com.pangding.web.tright.dao.UserDao;
import com.pangding.web.tright.dto.UserDto;
import com.pangding.web.tright.service.UserService;
import com.pangding.web.tright.vo.UserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author zhangjinyao
 */
@RestController
@RequestMapping(value = "/user")
public class UserController {

    @Autowired
    UserService userServiceImpl;
    @Autowired
    private UserDao userDao;
    /**
     * 新增用户
     * @param userDto
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object saveUser(@RequestBody UserDto userDto){

        UserVo u = userServiceImpl.getUser(userDto);

        if (u != null) {
            return new Result(4001,"该用户已存在",null);
        }

        String saltPassword = userServiceImpl.passwordEncoder(userDto.getPassword());
        userDto.setPassword(saltPassword);
        userDao.create(userDto);
        if (userDto.getRoleIds()!=null&&userDto.getRoleIds().size()!=0){
           userServiceImpl.userAndRole(userDto);
        }

        Result result = new Result(0,"SUCCESS",null);

        return result;
    }

    /**
     * 修改用户信息
     * @param //userDto
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object updateUser(@RequestBody UserDto userDto){
        UserVo u = userDto;
        u.setPassword(userServiceImpl.passwordEncoder(u.getPassword()));
        userDao.update(u);
        userServiceImpl.userAndRole(userDto);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }

    /**
     * 查询用户列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object listUsers(){

        List<UserVo> userVoList = userServiceImpl.listUserVo();
        List<UserDto> userDtoList = new ArrayList(userVoList.size());

        for (int var1 = 0;var1 < userVoList.size();var1++){
            UserVo userVo = userVoList.get(var1);
            List<String> roleIdList = userServiceImpl.listRoleIdList(userVo);
            List<String> roleList = new ArrayList(roleIdList.size());
            for (int var2 = 0;var2 < roleIdList.size();++var2){
                String role = userServiceImpl.getRoleNameByRoleId(roleIdList.get(var2));
                roleList.add(role);
            }
            UserDto userDto = userServiceImpl.makeUserDto(userVo,roleIdList,roleList);
            userDtoList.add(userDto);
        }

        Result result = new Result(0,"SUCCESS",userDtoList);
        return result;
    }

    /**
     * 根据ID查询用户
     * @param //id
     * @return
     */
    @RequestMapping(value = "/user", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object user(String userId){//@PathVariable Long id

        UserVo userVo = userServiceImpl.getUserById(userId);
        if(userVo == null){
            return new Result(4001,"该用户不存在",null);
        }
        List<String> roleIdList = userServiceImpl.listRoleIdList(userVo);
        List<String> roleList = new ArrayList(roleIdList.size());
        for (int var2 = 0;var2 < roleIdList.size();var2++){
            String role = userServiceImpl.getRoleNameByRoleId(roleIdList.get(var2));
            roleList.add(role);
        }
        UserDto userDto = userServiceImpl.makeUserDto(userVo,roleIdList,roleList);
        Result result = new Result(0,"SUCCESS",userDto);
        return result;
    }

}
