package com.pangding.web.tright.service;

import com.pangding.web.tright.dto.RoleDto;
import com.pangding.web.tright.vo.RoleVo;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface RoleService {

    /**
     * 保存RoleVo对象
     *
     * @param roleVo RoleVo对象
     */
    void saveRole(RoleVo roleVo);

    /**
     * 通过主键id查询RoleVo对象
     *
     * @param id 主键
     * @return RoleVo对象
     */
    RoleVo getRoleById(String id);

    /**
     * 通过角色名查询RoleVo对象
     *
     * @param name 角色名
     * @return RoleVo对象
     */
    RoleVo getRoleByName(String name);

    /**
     * 保存角色与权限的对应关系
     *
     * @param roleDto RoleDto对象
     */
    void roleAndTright(RoleDto roleDto);

    /**
     * 检查角色名是否已存在
     *
     * @param roleVo RoleVo对象
     * @return 角色名是否存在
     */
    Boolean checkNameExist(RoleVo roleVo);

    /**
     * 获取RoleVo对象列表
     *
     * @return RoleVo对象列表
     */
    List<RoleVo> getRoleVoList();

    /**
     * 通过角色id查询该角色权限id列表
     *
     * @param roleId 角色id
     * @return 权限id列表
     */
    List<String> getTrightIdList(String roleId);

    /**
     * 通过权限id查询权限名
     *
     * @param trightId 权限id
     * @return 权限名
     */
    String getTrightNameByTrightId(String trightId);

    /**
     * 将RoleVo对象添加权限ID列表和权限名列表封装成RoleDto对象
     *
     * @param roleVo RoleVo对象
     * @param trightIdList 权限id列表
     * @param trightNameList 权限名列表
     * @return RoleDto对象
     */
    RoleDto makeRoleDto(RoleVo roleVo,List<String> trightIdList,List<String> trightNameList);

    /**
     * 通过角色id删除角色
     *
     * @param roleId 角色id
     */
    void deleteRole(String roleId);

    /**
     * 通过角色id删除角色与用户的对应关系
     *
     * @param roleId 角色id
     */
    void deleteRoleUser(String roleId);

    /**
     * 通过角色id删除角色权限的对应关系
     *
     * @param roleId 角色id
     */
    void deleteRoleTright(String roleId);

    /**
     * 通过角色id获取角色用户关系表主键列表
     *
     * @param roleId 角色id
     * @return 角色用户关系表主键列表
     */
    List<String> getRoleUserPKListByRoleId(String roleId);

    /**
     * 通过角色id获取角色权限主键列表
     *
     * @param roleId 角色id
     * @return 角色权限主键列表
     */
    List<String> getRoleTrightPKListByRoleId(String roleId);
}
