package com.pangding.web.tright.service.impl;

import com.pangding.web.tright.dao.RoleTrightDao;
import com.pangding.web.tright.dao.TrightDao;
import com.pangding.web.tright.service.TrightService;
import com.pangding.web.tright.vo.TrightVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author zhangjinyao
 */
@Service
public class TrightServiceImpl implements TrightService {

    @Autowired
    TrightDao trightDao;

    @Autowired
    RoleTrightDao roleTrightDao;

    @Override
    public void save(TrightVo trightVo) {
        trightDao.create(trightVo);
    }

    @Override
    public void update(TrightVo trightVo) {
        trightDao.update(trightVo);
    }

    @Override
    public Boolean checkValid(TrightVo trightVo) {
        int checkResult = trightDao.checkValid(trightVo);
        if(checkResult == 0){return true;}
        else{return false;}
    }

    @Override
    public TrightVo getTrightById(String id) {
        TrightVo trightVo = trightDao.getTrightById(id);
        return trightVo != null ? trightVo : null;
    }

    @Override
    public void deleteTrightById(String id) {
        trightDao.remove(id);
    }

    @Override
    public List<TrightVo> listAllTright() {
        List<TrightVo> list = trightDao.listAll();
        return (list != null && list.size() != 0) ? list : null;
    }

    @Override
    public List<TrightVo> listLevel1() {
        List<TrightVo> list = trightDao.listLevel1();
        return (list != null && list.size() != 0) ? list : null;
    }

    @Override
    public Boolean checkChild(String id) {
        int childNum = trightDao.checkChild(id);
        return childNum == 0 ? true : false;
    }

    @Override
    public List<String> getChildIdList(String id) {

        return trightDao.getChildIdList(id);
    }

    @Override
    public List<String> getRoleTrightPKListByTrightId(String id) {

        return roleTrightDao.getRoleTrightPKListByTrightId(id);
    }

    @Override
    public void deleteRoleTright(String roleTrightId) {

        roleTrightDao.remove(roleTrightId);
    }
}
