package com.pangding.web.tright.controller;


import com.pangding.web.tright.currency.Result;
import com.pangding.web.tright.dao.RoleDao;
import com.pangding.web.tright.dto.RoleDto;
import com.pangding.web.tright.service.RoleService;
import com.pangding.web.tright.vo.RoleVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangjinyao
 */
@RestController
@RequestMapping("/roles")
public class RoleController {

    @Autowired
    RoleService roleServiceImpl;
    @Autowired
    RoleDao roleDao;
    /**
     * 新增角色
     * @param roleDto
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object saveRole(@RequestBody RoleDto roleDto){
        String id = roleDto.getId();
        String name = roleDto.getName();
        if (roleServiceImpl.getRoleById(id) != null){
            return new Result(4001, "该角色ID已存在", null);
        }
        if (roleServiceImpl.getRoleByName(name) != null){
            return new Result(4001, "该角色名已存在", null);
        }
        roleServiceImpl.saveRole((RoleVo)roleDto);
        roleServiceImpl.roleAndTright(roleDto);
        return new Result(0,"SUCCESS",null);
    }

    /**
     * 修改角色信息
     * @param roleDto
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object updateRole(@RequestBody RoleDto roleDto){
        RoleVo roleVo = roleDto;
        if (!roleServiceImpl.checkNameExist(roleVo)){
            return new Result(4001,"该角色名已存在",null);
        }
        roleServiceImpl.saveRole(roleVo);
        roleServiceImpl.roleAndTright(roleDto);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }

    /**
     * 查询角色列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object listRoles(){
        List<RoleVo> roleVoList = roleServiceImpl.getRoleVoList();
        List<RoleDto> roleDtoList = new ArrayList(roleVoList.size());
        if (roleVoList == null || roleVoList.size() == 0){
            return new Result(0,"暂无角色信息",null);
        }
        for (RoleVo roleVo:roleVoList) {
            List<String> trightIdList = roleServiceImpl.getTrightIdList(roleVo.getId());
            List<String> trightNameList = new ArrayList(trightIdList.size());
            for (String trightId:trightIdList) {
                String trightName = roleServiceImpl.getTrightNameByTrightId(trightId);
                trightNameList.add(trightName);
            }
            RoleDto roleDto = roleServiceImpl.makeRoleDto(roleVo,trightIdList,trightNameList);
            roleDtoList.add(roleDto);
        }
        Result result = new Result(0,"SUCCESS",roleDtoList);
        return result;
    }



    /**
     * 根据ID查询角色
     * @param
     * @return
     */
    @RequestMapping(value = "/role", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object role(@PathVariable String roleId){
        RoleVo roleVo = roleServiceImpl.getRoleById(roleId);
        List<String> trightIdList = roleServiceImpl.getTrightIdList(roleId);
        List<String> trightNameList = new ArrayList(trightIdList.size());
        for (String trightId:trightIdList) {
            String trightName = roleServiceImpl.getTrightNameByTrightId(trightId);
            trightNameList.add(trightName);
        }
        RoleDto roleDto = roleServiceImpl.makeRoleDto(roleVo,trightIdList,trightNameList);
        Result result = new Result(0,"SUCCESS",roleDto);
        return result;
    }

    /**
     * 删除角色
     * @param
     * @return
     */
    @RequestMapping(value = "/delete/{roleId}", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object delete(@PathVariable String roleId){
        roleServiceImpl.deleteRole(roleId);
        List<String> roleUserList = roleServiceImpl.getRoleUserPKListByRoleId(roleId);
        for (String roleUserId:roleUserList) {
            roleServiceImpl.deleteRoleUser(roleUserId);
        }

        List<String> roleTrightList = roleServiceImpl.getRoleTrightPKListByRoleId(roleId);
        for (String roleTrightId:roleTrightList) {
            roleServiceImpl.deleteRoleTright(roleTrightId);
        }
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }
}
