package com.pangding.web.tright.dao.impl;

import com.pangding.web.tright.dao.UserDao;
import com.pangding.web.tright.dto.UserDto;
import com.pangding.web.tright.vo.UserRoleRelation;
import com.pangding.web.tright.vo.UserVo;
import com.yanzuoguang.dao.DaoConst;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.MapRow;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.PageSizeReqVo;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * @author zhangjinyao
 */
@Component
public class UserDaoImpl extends BaseDaoImpl implements UserDao {


    private static final String GET_USER = "GET_USER";
    private static final String DELETE_USER_ROLE="deleteUserRole";
    private static final String SAVE_USER_ROLE = "saveUserRoles";
    private static final String GET_ALL_USERS = "GET_ALL_USERS";
    private static final String GET_ROLE_IDS = "GET_ROLE_IDS";
    private static final String GET_USER_BY_ID = "GET_USER_BY_ID";
    private static final String GET_ROLE_BY_ROLEID = "GET_ROLE_BY_ROLEID";

    @Override
    protected void init() {
        register(UserVo.class);

        table.add(GET_USER, "SELECT  id,account,phone,status,remark,create_time,creator FROM pd_user  WHERE 1=1 ")
                .add("account", " AND account = ?");

        table.add(DELETE_USER_ROLE,"delete from pd_user_role_relation where 1=1 ")
                .add("userId","and user_id = ?");

        table.add(GET_ALL_USERS,"select id,account,phone,status,remark,create_time,creator from pd_user where 1=1");

        table.add(GET_ROLE_IDS,"select role_id from pd_user_role where 1=1 ")
                .add("userId","and user_id = ?");

        table.add(GET_USER_BY_ID,"select id,account,phone,status,remark,create_time,creator from pd_user where 1=1 ")
                .add("userId","and user_id = ?");

        table.add(GET_ROLE_BY_ROLEID,"select name from pd_role where 1=1 ")
                .add("roleId","and id = ?");

    }

    @Override
    public UserVo getUser(UserVo userVo) {
        return this.queryFirst(UserVo.class, GET_USER, userVo);
    }


    @Override
    public List<UserVo> listUserVo() {

        return this.query(UserVo.class,GET_ALL_USERS,null);

    }

    @Override
    public List<String> getRoleIdList(UserVo userVo) {
        return this.query(String.class,GET_ROLE_IDS,userVo);
    }

    @Override
    public String getRoleNameByRoleId(String roleId) {
        return this.queryFirst(String.class,GET_ROLE_BY_ROLEID,roleId);
    }

    @Override
    public UserVo getUserById(String userId) {
        return this.queryFirst(UserVo.class,GET_USER_BY_ID,userId);
    }
}
