package com.pangding.web.tright.dao.impl;

import com.pangding.web.tright.dao.UserRoleDao;
import com.pangding.web.tright.vo.UserRoleRelation;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhangjinyao
 */
@Component
public class UserRoleDaoImpl extends BaseDaoImpl implements UserRoleDao {

    private static final String GET_ROLE_USER_PK_BY_ROLEID = "GET_ROLE_USER_PK_BY_ROLEID";

    @Override
    protected void init() {

        register(UserRoleRelation.class);

        table.add(GET_ROLE_USER_PK_BY_ROLEID,"select id from pd_user_role where 1=1 ")
                .add("roleId","and role_id = ?");

    }

    @Override
    public List<String> getRoleUserPKListByRoleId(String roleId) {
        return this.query(String.class,GET_ROLE_USER_PK_BY_ROLEID,roleId);
    }
}
