package com.pangding.web.tright.service;

import com.pangding.web.tright.dto.UserDto;
import com.pangding.web.tright.vo.UserVo;

import java.lang.reflect.Array;
import java.util.List;

/**
 * @author zhangjinyao
 */
public interface UserService {

    /**
     * 保存用户和角色的对应关系
     *
     * @param userDto UserDto对象
     */
    void userAndRole(UserDto userDto);

    /**
     * 通过UserVo对象获取相同的UserVo对象
     *
     * @param userVo UserVo对象
     * @return UserVo对象
     */
    UserVo getUser(UserVo userVo);

    /**
     * 对密码进行MD5盐值加密
     *
     * @param password 密码
     * @return 加密后的密码
     */
    String passwordEncoder(String password);

    /**
     * 获取UserVo对象列表
     *
     * @return UserVo对象列表
     */
    List<UserVo> listUserVo();

    /**
     * 通过UserVo对象获取该用户的角色ID列表
     *
     * @param userVo UserVo对象
     * @return 角色id列表
     */
    List<String> listRoleIdList(UserVo userVo);

    /**
     * 通过角色id获取角色名
     *
     * @param roleId 角色id
     * @return 角色名
     */
    String getRoleNameByRoleId(String roleId);

    /**
     * 将UserVo对象添加角色id列表和角色名列表封装成UserDto对象
     *
     * @param userVo UserVo对象
     * @param roleIdList 角色id列表
     * @param roleNameList 角色名列表
     * @return UserDto对象
     */
    UserDto makeUserDto(UserVo userVo,List<String> roleIdList,List<String> roleNameList);

    /**
     * 通过用户id查询UserVo对象
     *
     * @param userId 用户id
     * @return UserVo对象
     */
    UserVo getUserById(String userId);
}
