package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CompanyMoneyDao;
import com.pangding.web.vo.system.pd.company.CompanyMoneyVo;
import com.pangding.web.vo.system.req.company.CompanyMoneyReqVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

@Component
public class CompanyMoneyDaoImpl extends BaseDaoImpl implements CompanyMoneyDao {

    private final static String QUERY_LIST = "QUERY_LIST";

    private final static String QUERT_REPORT = "QUERT_REPORT";

    private final static String UPDATE_MONEY = "UPDATE_MONEY";

    public static final String LAST_INFO = "LAST_INFO";

    @Override
    protected void init() {

        register(CompanyMoneyVo.class);

        table.add(QUERY_LIST, "SELECT * FROM pd_company_money WHERE 1=1 {WHERE}")
                .add("companyId", " AND company_id = ? ")
                .add("startDate", " AND daily_date >= ?")
                .add("endDate", " AND daily_date <= ?")
                .add("companyName", " AND company_name like concat('%',?,'%') ");

        table.add(QUERT_REPORT, "SELECT SUM(init_money) as init_money,SUM(in_money) as in_money,SUM(out_money) as out_money," +
                "SUM(refund_money) as refund_money,SUM(final_money) as final_money,SUM(in_number) as in_number," +
                "SUM(out_number) as out_number,SUM(refund_number) as refund_number" +
                " FROM pd_company_money WHERE 1=1 {WHERE}")
                .add("companyId", " AND company_id = ? ")
                .add("startDate", " AND daily_date >= ?")
                .add("endDate", " AND daily_date <= ?")
                .add("companyName", " AND company_name like concat('%', ?, '%')");

        table.add(UPDATE_MONEY, "update pd_company_money set in_money = in_money + @inMoney,in_number= in_number + @inNumber," +
                "refund_number = refund_number + @refundNumber,refund_money = refund_money + @refundMoney," +
                "divide_number = divide_number + @divideNumber,divideMoney = divideMoney + @divideMoney," +
                "out_number = out_number + @outNumber,out_money = out_money + @outMoney," +
                "final_money = init_money + in_money + divide_money + refund_money + out_money " +
                " where company_money_id = @companyMoneyId");

        table.add(LAST_INFO, "SELECT * FROM pd_company_money WHERE 1=1 {WHERE} order by daily_date desc")
                .add("companyId", " AND company_id = ? ")
                .add("startDate", " AND daily_date >= ?")
                .add("endDate", " AND daily_date <= ?")
                .add("companyName", " AND company_name like concat('%',?,'%') ");

    }

    @Override
    public PageSizeData<CompanyMoneyVo> findCompanyMoneyPage(CompanyMoneyReqVo req) {
        return this.queryPage(CompanyMoneyVo.class, req, QUERY_LIST, req);
    }

    @Override
    public CompanyMoneyVo findReport(CompanyMoneyReqVo req) {
        return this.queryFirst(CompanyMoneyVo.class, QUERT_REPORT, req);
    }

    @Override
    public Integer updateCompanyMoney(CompanyMoneyVo req){
        return this.updateSql(UPDATE_MONEY, req);
    }

    @Override
    public CompanyMoneyVo findLastInfo(CompanyMoneyReqVo req) {
        return this.queryFirst(CompanyMoneyVo.class, LAST_INFO, req);
    }

}
