package com.pangding.web.tright.controller;


import com.pangding.web.tright.currency.Result;
import com.pangding.web.tright.dao.RoleDao;
import com.pangding.web.tright.dto.RoleDto;
import com.pangding.web.tright.service.RoleService;
import com.pangding.web.tright.vo.RoleVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/roles")
public class RoleController {

    @Autowired
    RoleService roleServiceImpl;
    @Autowired
    RoleDao roleDao;
    /**
     * 新增角色
     * @param roleDto
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object saveRole(@RequestBody RoleDto roleDto){
        roleServiceImpl.saveRole(roleDto);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }

    /**
     * 修改角色信息
     * @param roleDto
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object updateRole(@RequestBody RoleDto roleDto){
        roleServiceImpl.saveRole(roleDto);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }

    /**
     * 查询角色列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object listRoles(){

        Result result = new Result(0,"SUCCESS",null);
        return result;
    }



    /**
     * 根据ID查询角色
     * @param id
     * @return
     */
    @RequestMapping(value = "/role", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object role(@PathVariable Long id){
        RoleVo roleVo = roleDao.getById(id);
        Result result = new Result(0,"SUCCESS",roleVo);
        return result;
    }

    /**
     * 删除角色
     * @param id
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object delete(@PathVariable Long id){
        roleServiceImpl.deleteRole(id);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }
}
