package com.pangding.web.tright.controller;


import com.pangding.web.tright.currency.Result;
import com.pangding.web.tright.dao.UserDao;
import com.pangding.web.tright.dto.UserDto;
import com.pangding.web.tright.service.UserService;
import com.pangding.web.tright.vo.UserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.Date;

@RestController
@RequestMapping("/user")
public class UserController {

    @Autowired
    UserService userServiceImpl;
    @Autowired
    private UserDao userDao;
    /**
     * 新增用户
     * @param //userDto
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object saveUser(){//@RequestBody UserDto userDto
//        UserVo u = userServiceImpl.getUser(userDto.getUserName());
//        if (u != null) {
//            throw new IllegalArgumentException(userDto.getUserName() + "已存在");
//        }
        UserDto userDto = new UserDto();
        userDto.setUserName("test");
        userDto.setPassword("123456");
        userDto.setPhoneNumber("123456789110");
        userDto.setCreateTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        userDto.setCount(0);
        UserVo userVo = userServiceImpl.saveUser(userDto);
        Result result = new Result(0,"SUCCESS",userVo);
        return result;
    }

    /**
     * 修改用户信息
     * @param userDto
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object updateUser(@RequestBody UserDto userDto){
        UserVo userVo = userServiceImpl.updateUser(userDto);
        Result result = new Result(0,"SUCCESS",userVo);
        return result;
    }

    /**
     * 查询用户列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object listUsers(){



        Result result = new Result(0,"SUCCESS",null);
        return result;
    }

    /**
     * 根据ID查询用户
     * @param //id
     * @return
     */
    @RequestMapping(value = "/user", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object user(){//@PathVariable Long id

        UserVo vo = userDao.load(null,UserVo.class);
        //UserVo userVo = userDao.getById(id);
        Result result = new Result(0,"SUCCESS",vo);
        return result;
    }

}
