package com.pangding.web.authority.controller;

import com.pangding.web.authority.cloudvo.ComputerRegisterUserReturnVo;
import com.pangding.web.authority.currency.Result;
import com.pangding.web.authority.dto.RegisterEnterpriceDto;
import com.pangding.web.authority.dto.RegisterIndividualDto;
import com.pangding.web.authority.dto.RegisterUserDto;
import com.pangding.web.authority.service.MobileRegisterService;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.utils.Md5AndSalt;
import com.pangding.web.authority.vo.CompanyVo;
import com.pangding.web.authority.vo.MobileLoginInfo;
import com.pangding.web.authority.vo.UserVo;
import com.yanzuoguang.token.TokenHelper;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author zhangjinyao
 * @create 2019/5/14 16:28
 */

@RestController
@RequestMapping(value="/computer")
public class ComputerRegisterController {
    @Autowired
    MobileRegisterService mobileRegisterServiceImpl;
    @Autowired
    UserService userServiceImpl;

    /**
     * 验证注册第一页数据的合法性并保存
     *
     * @param registerUserDto
     * @return
     */
    @RequestMapping(value = "/user", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object saveUser(@RequestBody RegisterUserDto registerUserDto){

        if (!userServiceImpl.isValid(registerUserDto.getAccount())){
            return new Result(4001,"用户名由字母与数字组成，且不能为纯数字",registerUserDto);
        }

        UserVo userVo = new UserVo();
        userVo.setAccount(registerUserDto.getAccount());
        userServiceImpl.checkAccount(userVo);

        String merchantId = registerUserDto.getMerchantId();
        if (!mobileRegisterServiceImpl.checkMerchantId(merchantId)){
            return new Result(4001,"注册编码错误",registerUserDto);
        }

        String companyId = StringHelper.getNewID();
        userVo.setPassword(Md5AndSalt.generate(registerUserDto.getPassword()));
        userVo.setId(StringHelper.getNewID());
        userVo.setRemark(registerUserDto.getPassword());
        userVo.setCompanyId(companyId);
        mobileRegisterServiceImpl.saveUser(userVo);
        ComputerRegisterUserReturnVo returnVo = new ComputerRegisterUserReturnVo();
        returnVo.setCompanyId(companyId);
        returnVo.setMerchantId(merchantId);
        returnVo.setCompanyType(registerUserDto.getCompanyType());

        /*token内容暂时不能用，以后要改动，需要存入用户及企业信息*/
        String token = StringHelper.getNewID();
        TokenHelper.write(token,returnVo);

        return new Result(0,"SUCCESS",null);
    }

    /**
     * 当用户类型选择为“个体”时进入此方法
     * 验证注册第二页数据的合法性并保存
     *
     * @param individualDto
     * @return
     */
    @RequestMapping(value="/individual", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object saveIndividual(@RequestBody RegisterIndividualDto individualDto){

        mobileRegisterServiceImpl.checkPhone(individualDto);

        CompanyVo companyVo = new CompanyVo();

        /*token内容暂时不能用，以后要改动*/
        ComputerRegisterUserReturnVo returnVo = TokenHelper.get(ComputerRegisterUserReturnVo.class);

        companyVo.setId(returnVo.getCompanyId());
        companyVo.setCompanyType(returnVo.getCompanyType());
        companyVo.setMerchantId(returnVo.getMerchantId());
        companyVo.setContactName(individualDto.getContactName());
        companyVo.setContactCode(individualDto.getContactCode());
        companyVo.setCompanyAttribute(individualDto.getCompanyAttribute());
        companyVo.setContactPhone(individualDto.getContactPhone());
        if (individualDto.getCompanyAttribute().equals("5")){
            companyVo.setCompanyName(individualDto.getExtraChoseOne());
            companyVo.setBusinessLicenseCode(individualDto.getExtraChoseTwo());
        }else{
            companyVo.setCompanyName(individualDto.getExtraChoseOne());
            companyVo.setAddress(individualDto.getExtraChoseTwo());
        }
        mobileRegisterServiceImpl.saveCompany(companyVo);
        return new Result(0,"SUCCESS",null);
    }

    @RequestMapping(value="/enterprise", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object saveEnterprise(@RequestBody RegisterEnterpriceDto enterpriceDto){
        return null;
    }

    @RequestMapping(value = "/login", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object login(@RequestBody MobileLoginInfo info){

        String accountOrPhone = info.getAccountOrPhone();
        UserVo userVo;
        if (userServiceImpl.isNumeric(accountOrPhone)){
            userVo = userServiceImpl.getUserByPhone(accountOrPhone);
        }else {
            userVo = userServiceImpl.getUserByAccount(accountOrPhone);
        }

        if (userVo == null){
            return new Result(4001,"没有此用户",info);
        }

        if (!Md5AndSalt.verify(info.getPassword(),userVo.getPassword())){
            return new Result(4001,"用户名或密码错误",info);
        }

        /*token内容暂时不能用，以后要改动*/
        String token = StringHelper.getNewID();
        TokenHelper.write(token,userVo);

        return new Result(0,"SUCCESS",null);
    }
}
