package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.RoleDao;
import com.pangding.web.authority.reqvo.GetRoleByRoleIdReqVo;
import com.pangding.web.authority.reqvo.GetRoleByRoleNameReqVo;
import com.pangding.web.authority.vo.RoleVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhangjinyao
 */
@Component
public class RoleDaoImpl extends BaseDaoImpl implements RoleDao {


    private static final String CHECK_NAME_EXIST = "CHECK_NAME_EXIST";
    private static final String SELECT = "SELECT";

    @Override
    protected void init() {
        register(RoleVo.class);

        table.addExist(CHECK_NAME_EXIST,"name");

        table.add(SELECT,"select * from pd_role where 1=1 ")
        .add("id","and pid = ?");

    }

    @Override
    public RoleVo getRoleById(GetRoleByRoleIdReqVo getRoleByRoleIdReqVo) {
        return this.load(getRoleByRoleIdReqVo,RoleVo.class);
    }

    @Override
    public RoleVo getRoleByRoleName(GetRoleByRoleNameReqVo getRoleByRoleNameReqVo) {
        return this.load(getRoleByRoleNameReqVo, RoleVo.class);
    }

    @Override
    public void checkNameExist(RoleVo roleVo){
        this.checkExist(CHECK_NAME_EXIST,roleVo,"角色名已存在");
    }

    @Override
    public List<RoleVo> getRoleVoList() {
        return this.query(RoleVo.class,SELECT,null);
    }

    @Override
    public List<RoleVo> getChild(GetRoleByRoleIdReqVo getRoleByRoleIdReqVo) {
        return this.query(RoleVo.class,SELECT,getRoleByRoleIdReqVo);
    }
}
