package com.pangding.web.authority.controller;

import com.pangding.web.authority.vo.reqvo.RegisterEnterpriceReqVo;
import com.pangding.web.authority.vo.reqvo.RegisterIndividualReqVo;
import com.pangding.web.authority.vo.reqvo.RegisterUserReqVo;
import com.pangding.web.authority.service.RegisterService;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.vo.CompanyVo;
import com.pangding.web.authority.vo.reqvo.LoginReqVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author zhangjinyao
 * @create 2019/5/14 16:28
 */

@RestController
@RequestMapping(value="/computerRegister")
public class ComputerRegisterController {
    @Autowired
    RegisterService registerServiceImpl;
    @Autowired
    UserService userServiceImpl;

    /**
     * 验证注册第一页数据的合法性并保存
     *
     * @param registerUserReqVo
     * @return
     */
    @RequestMapping(value = "/saveUser", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<CompanyVo> saveUser(@RequestBody RegisterUserReqVo registerUserReqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("account",registerUserReqVo.getAccount())
                .notBlankCheck("password",registerUserReqVo.getPassword())
                .notBlankCheck("confirmPassword",registerUserReqVo.getConfirmPassword())
                .notBlankCheck("companyType",registerUserReqVo.getCompanyType())
                .notBlankCheck("invitationCode",registerUserReqVo.getInvitationCode())
                .checkException();
        return ResponseResult.result(registerServiceImpl.saveUser(registerUserReqVo));
    }

    /**
     * 当用户类型选择为“个体”时进入此方法
     * 验证注册第二页数据的合法性并保存
     *
     * @param reqVo
     * @return
     */
    @RequestMapping(value="/saveIndividual", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult saveIndividual(@RequestBody RegisterIndividualReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("contactName",reqVo.getContactName())
                .notBlankCheck("contactCode",reqVo.getContactCode())
                .checkIdCard("contactCode",reqVo.getContactCode())
                .notBlankCheck("companyAttribute",reqVo.getCompanyAttribute())
                .notBlankCheck("companyName",reqVo.getCompanyName())
                .notBlankCheck("contactPhone",reqVo.getContactPhone())
                .checkPhoneNo("contactPhone",reqVo.getContactPhone())
                .checkException();
        registerServiceImpl.saveIndividual(reqVo);
        return new ResponseResult();
    }

    @RequestMapping(value="/enterprise", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult saveEnterprise(@RequestBody RegisterEnterpriceReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyName",reqVo.getCompanyName())
                .notBlankCheck("companyAddress",reqVo.getAddress())
                .notBlankCheck("businessLicenseCode",reqVo.getBusinessLicenseCode())
                .notNumberCheck("businessLicenseCode",reqVo.getBusinessLicenseCode())
                .notBlankCheck("merchantName",reqVo.getMerchantName())
                .notBlankCheck("companyAttribute",reqVo.getCompanyAttribute())
                .notBlankCheck("contactName",reqVo.getContactName())
                .notBlankCheck("contactCode",reqVo.getContactCode())
                .checkIdCard("contactCode",reqVo.getContactCode())
                .notBlankCheck("contactPhone",reqVo.getContactPhone())
                .checkPhoneNo("contactPhone",reqVo.getContactPhone())
                .notBlankCheck("bankName",reqVo.getBankName())
                .notBlankCheck("bankCardCode",reqVo.getBankCardCode())
                .notNumberCheck("bankCardCode",reqVo.getBankCardCode())
                .notBlankCheck("bankAddress",reqVo.getBankAddress())
                .notBlankCheck("bankCode",reqVo.getBankCode())
                .notNumberCheck("bankCode",reqVo.getBankCode())
                .notBlankCheck("reservedPhone",reqVo.getReservedPhone())
                .checkPhoneNo("reservedPhone",reqVo.getReservedPhone())
                .checkException();
        registerServiceImpl.saveEnterprise(reqVo);

        return new ResponseResult();
    }

    @RequestMapping(value = "/login", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult login(@RequestBody LoginReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("account or phone",reqVo.getAccountOrPhone())
                .notBlankCheck("pass",reqVo.getPassword())
                .checkException();
        registerServiceImpl.login(reqVo);
        return new ResponseResult();
    }


}
