package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.service.CompanyService;
import com.pangding.web.authority.util.CompanyConstant;
/*import com.pangding.web.authority.util.TokenUtil;*/
import com.pangding.web.authority.vo.*;
import com.pangding.web.authority.vo.cloudvo.LoginResVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.reqvo.CompanyGetReqVo;
import com.pangding.web.authority.service.RegisterService;
import com.pangding.web.authority.service.UserService;
/*import com.yanzuoguang.token.TokenHelper;*/
import com.yanzuoguang.token.TokenHelper;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:23
 */

@Service
public class RegisterServiceImpl implements RegisterService {

    @Autowired
    CompanyDao companyDaoImpl;
    @Autowired
    UserDao userDaoImpl;
    @Autowired
    UserService userServiceImpl;
    @Autowired
    CompanyExtendDao companyExtendDaoImpl;
    @Autowired
    CompanyBankCardDao companyBankCardDaoImpl;

    @Autowired
    private CompanyService companyService;

    @Override
    public CompanyExtendVo checkInvitationCode(String invitationCode) {
        CompanyExtendGetReqVo reqVo = new CompanyExtendGetReqVo();
        reqVo.setInvitationCode(invitationCode);
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(reqVo,CompanyExtendVo.class);
        return companyExtendVo == null ? null : companyExtendVo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CompanyVo saveUser(RegisterUserReqVo registerUserReqVo) {

        // 检查账户是否合法
        userServiceImpl.isValid(registerUserReqVo.getAccount());

        UserVo userVo = new UserVo();
        userVo.setAccount(registerUserReqVo.getAccount());
        // 检查用户名是否存在
        userServiceImpl.checkAccount(userVo);

        if (!StringHelper.compare( registerUserReqVo.getPassword(), registerUserReqVo.getConfirmPassword())){
            throw new CodeException("确认密码错误");
        }

        CompanyExtendVo companyExtendVo = checkInvitationCode(registerUserReqVo.getInvitationCode());
        if (null == companyExtendVo){
            throw new CodeException("注册编码错误");
        }

        String companyId = StringHelper.getNewID();
        userVo.setPassword(StringHelper.md5(registerUserReqVo.getPassword()));
        userVo.setId(StringHelper.getNewID());
        userVo.setRemark(registerUserReqVo.getPassword());
        userVo.setCompanyId(companyId);
        userDaoImpl.create(userVo);
        CompanyVo companyVo = new CompanyVo();
        companyVo.setId(companyId);
        companyVo.setInvitationCompanyId(companyExtendVo.getId());
        companyVo.setCompanyType(registerUserReqVo.getCompanyType());
        companyDaoImpl.save(companyVo);
        return companyVo;
    }

    @Override
    public void checkPhone(String contactPhone) {
        CompanyVo companyVo = new CompanyVo();
        companyVo.setContactPhone(contactPhone);
        companyDaoImpl.checkPhone(companyVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveIndividual(RegisterIndividualReqVo reqVo) {

        this.checkPhone(reqVo.getContactPhone());

        CompanyVo companyVo = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo,reqVo);
        companyDaoImpl.update(companyVo);

        CompanyExtendVo extendVo = new CompanyExtendVo();
        extendVo.setId(reqVo.getId());
        companyExtendDaoImpl.create(extendVo);

        CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
        companyBankCardVo.setCompanyId(reqVo.getId());
        companyBankCardVo.setId(StringHelper.getNewID());
        companyBankCardDaoImpl.create(companyBankCardVo);

        UserVo userReqVo = new UserVo();
        userReqVo.setCompanyId(reqVo.getId());
        UserVo userVo = userDaoImpl.load(userReqVo,UserVo.class);
        userVo.setPhone(reqVo.getContactPhone());
        userDaoImpl.update(userVo);

        //        此处需要保存数据到merchant表中
        MerchantVo merchantVo = new MerchantVo();
        merchantVo.setId(StringHelper.getNewID());
        merchantVo.setName(reqVo.getCompanyName());
        merchantVo.setAddress(reqVo.getAddress());
        merchantVo.setType(reqVo.getCompanyAttribute());
        merchantVo.setProductCompanyId(reqVo.getId());
        merchantVo.setUserId(userVo.getId());
        merchantVo.setUserName(userVo.getAccount());

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveEnterprise(RegisterEnterpriceReqVo reqVo) {

        this.checkPhone(reqVo.getContactPhone());

        CompanyVo companyVo = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo,reqVo);
        companyDaoImpl.update(companyVo);

        CompanyExtendVo extendVo = new CompanyExtendVo();
        extendVo.setId(reqVo.getId());
        companyExtendDaoImpl.create(extendVo);

        CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
        companyBankCardVo.setId(StringHelper.getNewID());
        companyBankCardVo.setCompanyId(reqVo.getId());
        companyBankCardVo.setBankName(reqVo.getBankName());
        companyBankCardVo.setBankCardCode(reqVo.getBankCardCode());
        companyBankCardVo.setBankAddress(reqVo.getBankAddress());
        companyBankCardVo.setBankCode(reqVo.getBankCode());
        companyBankCardVo.setReservedPhone(reqVo.getReservedPhone());
        companyBankCardDaoImpl.create(companyBankCardVo);

        UserVo userReqVo = new UserVo();
        userReqVo.setCompanyId(reqVo.getId());
        UserVo userVo = userDaoImpl.load(userReqVo,UserVo.class);
        userVo.setPhone(reqVo.getContactPhone());
        userDaoImpl.update(userVo);

        //        此处需要保存数据到merchant表中
        MerchantVo merchantVo = new MerchantVo();
        merchantVo.setId(StringHelper.getNewID());
        merchantVo.setName(reqVo.getCompanyName());
        merchantVo.setAddress(reqVo.getAddress());
        merchantVo.setType(reqVo.getCompanyAttribute());
        merchantVo.setProductCompanyId(reqVo.getId());
        merchantVo.setUserId(userVo.getId());
        merchantVo.setUserName(userVo.getAccount());
    }

    @Override
    public void login(LoginReqVo reqVo) {
        String accountOrPhone = reqVo.getAccountOrPhone();
        UserVo userVo;
        if (userServiceImpl.isNumeric(accountOrPhone)){
            userVo = userServiceImpl.getUserByPhone(accountOrPhone);
        }else {
            userVo = userServiceImpl.getUserByAccount(accountOrPhone);
        }

        if (userVo == null){
            throw new CodeException("没有此用户");
        }

        if (!StringHelper.md5(reqVo.getPassword()).equals(userVo.getPassword())){
            throw new CodeException("用户名或密码错误");
        }

        CompanyVo companyReqVo = new CompanyVo();
        CompanyBankCardVo companyBankCardReqVo = new CompanyBankCardVo();
        CompanyExtendVo companyExtendReqVo = new CompanyExtendVo();

        companyReqVo.setId(userVo.getCompanyId());
        CompanyVo companyVo = companyDaoImpl.load(companyReqVo,CompanyVo.class);
        companyBankCardReqVo.setCompanyId(userVo.getCompanyId());
        CompanyBankCardVo companyBankCardVo = companyBankCardDaoImpl.load(companyBankCardReqVo,CompanyBankCardVo.class);
        companyExtendReqVo.setId(userVo.getCompanyId());
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(companyExtendReqVo,CompanyExtendVo.class);

        LoginResVo resVo = new LoginResVo();
        resVo.setUserVo(userVo);
        resVo.setCompanyVo(companyVo);
        resVo.setCompanyBankCardVo(companyBankCardVo);
        resVo.setCompanyExtendVo(companyExtendVo);
//        此处需要获取对应的merchant表数据
        /*String token = TokenUtil.createToken(reqVo.getAccountOrPhone());
        TokenHelper.write(token,resVo);*/
    }
}
