package com.pangding.web.authority.vo;

import com.yanzuoguang.dao.TableAnnotation;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.InitDao;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author zhangjinyao
 * @create 2019/5/21 11:31
 */
@TableAnnotation("pd_merchant")
public class MerchantVo implements Serializable, InitDao {
    private String id;

    private String code;

    private String name;

    private BigDecimal longitude;

    private BigDecimal latitude;

    private BigDecimal score;

    @TableAnnotation("area_code")
    private String areaCode;

    @TableAnnotation("area_name")
    private String areaName;

    private String address;

    private int type;

    private String tag;

    private String level;

    private int status;

    @TableAnnotation("time_spent")
    private String timeSpent;

    private String phone;

    @TableAnnotation("product_company_id")
    private String productCompanyId;

    @TableAnnotation("interface_company_id")
    private String interfaceCompanyId;

    @TableAnnotation("business_start")
    private String businessStart;

    @TableAnnotation("business_end")
    private String businessEnd;

    @TableAnnotation("create_time")
    private String createTime;

    @TableAnnotation("user_id")
    private String userId;

    private String userName;

    private String source;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public BigDecimal getScore() {
        return score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getTimeSpent() {
        return timeSpent;
    }

    public void setTimeSpent(String timeSpent) {
        this.timeSpent = timeSpent;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getProductCompanyId() {
        return productCompanyId;
    }

    public void setProductCompanyId(String productCompanyId) {
        this.productCompanyId = productCompanyId;
    }

    public String getInterfaceCompanyId() {
        return interfaceCompanyId;
    }

    public void setInterfaceCompanyId(String interfaceCompanyId) {
        this.interfaceCompanyId = interfaceCompanyId;
    }

    public String getBusinessStart() {
        return businessStart;
    }

    public void setBusinessStart(String businessStart) {
        this.businessStart = businessStart;
    }

    public String getBusinessEnd() {
        return businessEnd;
    }

    public void setBusinessEnd(String businessEnd) {
        this.businessEnd = businessEnd;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public void init() {
        this.createTime = StringHelper.getFirst(this.createTime, DateHelper.getNow());
    }
}
