package com.pangding.web.demo.feign;

import com.yanzuoguang.util.vo.LogVo;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * LogInterFeign
 *
 * @author: Kang
 * @time: 2018年04月25日 14:00
 */
@FeignClient(value = "tbd-log")
public interface DemoLogFeign {

    /**
     * 请求日志服务
     *
     * @param logVo
     */
    @RequestMapping(value = "/log/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseResult<String> save(LogVo logVo);
}
