package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.AuthorityDao;
import com.pangding.web.authority.vo.AuthorityVo;
import com.pangding.web.authority.vo.reqvo.ListAuthorityByPageReqVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

/**
 * @author zhangjinyao
 */
@Component
public class AuthorityDaoImpl extends BaseDaoImpl implements AuthorityDao {

    private static final String CHECK_VALID = "CHECK_VALID";
    private static final String SELECT = "SELECT";

    @Override
    protected void init() {
        register(AuthorityVo.class);

        table.addExist(CHECK_VALID,"name","url");

        table.add(SELECT,"select * from pd_authority where 1=1")
                .add("id","and pid = ? ")
                .add("pid","and pid = ? ")
                .add("sort","and sort = ?")
                .add("levelOne","and pid = ''");
    }

    /**
     * 检查新建或修改的authorityVo对象是否合法
     *
     * @param authorityVo authorityVo对象
     */
    @Override
    public void checkValid(AuthorityVo authorityVo) {
        this.checkExist(CHECK_VALID,authorityVo,"该权限不合法，请修改权限名或权限url");
    }

    /**
     * 获取权限分页对象
     *
     * @param reqVo
     * @return 权限分页对象
     */
    @Override
    public PageSizeData<AuthorityVo> getAuthorityList(ListAuthorityByPageReqVo reqVo) {
        return this.queryPage(AuthorityVo.class,reqVo,SELECT,reqVo);
    }

}
