package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.WechatUserDao;
import com.pangding.web.authority.vo.WechatUserVo;
import com.pangding.web.authority.vo.reqvo.WechatUserGetReqVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

/**
 * @Author zhangjinyao
 * @create 2019/5/29 17:13
 */
@Component
public class WechatUserDaoImpl extends BaseDaoImpl implements WechatUserDao {
    private static final String GET_USER_PRECIPITATION = "GET_USER_PRECIPITATION";

    @Override
    protected void init() {
        register(WechatUserVo.class);

        table.add(GET_USER_PRECIPITATION,"select count(company_id) from pd_wechat_user where 1=1 ")
                .add("companyId","and company_id = ?");
    }

    /**
     * 通过公司id获取该公司的用户沉淀量
     * @param reqVo 封装了公司id的请求对象
     * @return  用户沉淀量
     */
    @Override
    public int getUserPrecipitation(WechatUserGetReqVo reqVo) {
        return this.queryFirst(int.class,GET_USER_PRECIPITATION,reqVo);
    }
}
