package com.pangding.web.authority.service;


import com.pangding.web.authority.vo.CompanyExtendVo;
import com.pangding.web.authority.vo.cloudvo.LoginResVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.CompanyVo;
import com.pangding.web.authority.vo.resvo.SaveCompanyResVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:21
 */
public interface RegisterService {

    /**
     * 判断注册编码是否存在
     *
     * @param invitationCode 注册编码
     * @return 若不存在，返回null，存在则返回CompanyExtendVo对象
     */
    CompanyExtendVo checkInvitationCode(String invitationCode);

    /**
     * 保存用户信息，并返回公司信息
     *
     * @param registerUserReqVo
     * @return CompanyVo对象
     */
    CompanyVo saveUser(RegisterUserReqVo registerUserReqVo);

    /**
     * 检查电话号码是否已存在
     *
     * @param contactPhone 联系电话
     */
    void checkPhone(String id,String contactPhone);

    /**
     * 保存个人注册的公司信息
     *
     * @param reqVo
     * @return 返回保存数据各表的主键
     */
    SaveCompanyResVo saveIndividual(RegisterIndividualReqVo reqVo);

    /**
     * 保存企业注册的公司信息
     *
     * @param reqVo
     * @return 返回保存数据各表的主键
     */
    SaveCompanyResVo saveEnterprice(RegisterEnterpriceReqVo reqVo);

    /**
     * 登陆，验证用户名或手机号，密码是否正确
     * 返回token,account,LoginCompanyResVo对象（id：公司id,status：公司状态,companyAttribute：属性,bankCardCodeList：绑定的银行卡数组）
     *
     * @param reqVo
     * @return
     */
    LoginResVo login(LoginReqVo reqVo);

    LoginResVo verifyLogin(ComputerLoginReqVo reqVo, HttpSession session, HttpServletRequest request);

    String individualSubmit(IndividualSubmitReqVo reqVo);

    String enterpriceSubmit(EnterpriceSubmitReqVo reqVo);
}
