package com.tcm.common.dao.impl;

import com.tcm.common.dao.CenterDisplayDao;
import com.tcm.util.area.CenterDisplayVo;
import com.tcm.util.area.req.CenterDisplayReqVo;
import com.tcm.util.area.res.CenterDisplayLoadResVo;
import com.tcm.util.area.res.CenterDisplayResVo;
import com.tcm.util.area.res.FloorAreaResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CenterDisplayDaoImpl extends BaseDaoImpl implements CenterDisplayDao {

    private static final String SQL_LOAD_BY_LIST = "LOAD_BY_LIST";
    private static final String SQL_LOAD_BY_TYPE = "LOAD_BY_TYPE";
    private static final String SQL_LOAD_FLOOR_AREA_LIST = "LOAD_FLOOR_AREA_LIST";

    @Override
    protected void init() {
        register(CenterDisplayVo.class);
        table.add(SQL_LOAD_BY_LIST, "select p.*,pi.image_url as iconUrl from tcm_center_display as p " +
                "left join tcm_image as pi on p.display_id on pi.relation_id  where 1=1 {WHERE} order by p.sort")
                .add("displayId", "p.display_id = ?")
                .add("title", "p.title = ?")
        ;
        table.add(SQL_LOAD_BY_TYPE, "select p.* from tcm_center_display as p where 1=1 {WHERE} group by p.content_type");
        table.add(SQL_LOAD_FLOOR_AREA_LIST, "select fa.*,p.content_type as contentType from tcm_center_display as p " +
                "left join tcm_floor_area as fa on p.area_id on fa.area_id  where 1=1 {WHERE} order by p.sort")
                .add("areaId", "p.area_id = ?")
                .add("title", "p.title = ?")
                .add("contentType", "p.content_type = ?")
        ;
    }

    @Override
    public List<CenterDisplayResVo> loadByList(CenterDisplayVo req) {
        return this.query(CenterDisplayResVo.class, SQL_LOAD_BY_LIST, req);
    }

    @Override
    public List<CenterDisplayLoadResVo> loadByType(CenterDisplayReqVo req) {
        return this.query(CenterDisplayLoadResVo.class, SQL_LOAD_BY_TYPE, req);
    }

    @Override
    public List<FloorAreaResVo> loadFloorAreaList(CenterDisplayReqVo req) {
        return this.query(FloorAreaResVo.class, SQL_LOAD_FLOOR_AREA_LIST, req);
    }
}
