package com.tcm.common.service;

import com.tcm.util.area.req.FloorAreaReqVo;
import com.tcm.util.area.req.FloorLoadPageReqVo;
import com.tcm.util.area.req.FloorReqVo;
import com.tcm.util.area.res.FloorAreaResVo;
import com.tcm.util.area.res.FloorResVo;
import com.yanzuoguang.util.vo.PageSizeData;

public interface AreaService {
    /**
     * 楼层保存
     * @param req
     * @return
     */
    String floorSave(FloorReqVo req);
    /**
     * 楼层加载
     * @param req
     * @return
     */
    FloorResVo floorLoad(FloorReqVo req);
    /**
     * 楼层分页查询
     * @param req
     * @return
     */
    PageSizeData<FloorResVo> loadPage(FloorLoadPageReqVo req);
    /**
     * 楼层删除
     * @param req
     * @return
     */
    String floorRemove(FloorReqVo req);
    /**
     * 区域加载
     * @param req
     * @return
     */
    FloorAreaResVo areaLoad(FloorAreaReqVo req);
    /**
     * 区域保存
     * @param req
     * @return
     */
    String areaSave(FloorAreaReqVo req);
    /**
     * 区域删除
     * @param req
     * @return
     */
    String areaRemove(FloorAreaReqVo req);
}
