package com.tcm.common.service.impl;

import com.tcm.common.dao.CenterDisplayDao;
import com.tcm.common.dao.ImageDao;
import com.tcm.common.service.CenterDisplayService;
import com.tcm.common.util.CommonConstant;
import com.tcm.util.area.CenterDisplayVo;
import com.tcm.util.area.req.CenterDisplayReqVo;
import com.tcm.util.area.res.CenterDisplayHomeLoadResVo;
import com.tcm.util.area.res.CenterDisplayLoadResVo;
import com.tcm.util.area.res.CenterDisplayResVo;
import com.tcm.util.area.res.FloorAreaResVo;
import com.tcm.util.common.ImageVo;
import com.tcm.util.common.req.ImageReqVo;
import com.tcm.util.common.req.TcmEnumReqVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class CenterDisplayServiceImpl implements CenterDisplayService {

    private final CenterDisplayDao centerDisplayDao;
    private final ImageDao imageDao;

    public CenterDisplayServiceImpl(CenterDisplayDao centerDisplayDao,
                                    ImageDao imageDao) {
        this.centerDisplayDao = centerDisplayDao;
        this.imageDao = imageDao;
    }

    @Override
    public String save(CenterDisplayReqVo req) {
        if (StringHelper.isEmpty(req.getDisplayId())) {
            CenterDisplayVo centerDisplay = new CenterDisplayVo();
            String displayId = StringHelper.getNewID();
            centerDisplay.setDisplayId(displayId);
            ObjectHelper.writeWithFrom(centerDisplay, req);
            centerDisplay.setCreateTime(DateHelper.getNow());
            centerDisplayDao.save(centerDisplay);
            return displayId;
        } else {
            CenterDisplayVo centerDisplay = new CenterDisplayVo();
            centerDisplay.setDisplayId(req.getDisplayId());
            CenterDisplayVo load = centerDisplayDao.load(centerDisplay, CenterDisplayResVo.class);
            ObjectHelper.writeWithFrom(load, req);
            load.setUpdateTime(DateHelper.getNow());
            centerDisplayDao.update(load);
            return req.getDisplayId();

        }
    }

    @Override
    public CenterDisplayResVo load(CenterDisplayReqVo req) {
        CenterDisplayVo centerDisplay = new CenterDisplayVo();
        centerDisplay.setDisplayId(req.getDisplayId());
        return centerDisplayDao.load(centerDisplay, CenterDisplayResVo.class);

    }

    @Override
    public List<CenterDisplayResVo> loadList(CenterDisplayReqVo req) {
        List<CenterDisplayResVo> list = centerDisplayDao.loadByList(req);
        return list;
    }

    @Override
    public String remove(TcmEnumReqVo req) {
        CenterDisplayVo centerDisplay = new CenterDisplayVo();
        centerDisplay.setDisplayId(req.getEnumId());
        centerDisplayDao.remove(centerDisplay);
        return req.getEnumId();
    }

    @Override
    public CenterDisplayHomeLoadResVo loadCenter(CenterDisplayReqVo req) {
        CenterDisplayHomeLoadResVo loadRes = new CenterDisplayHomeLoadResVo();
        //展示图加载
        ImageReqVo imageVo = new ImageReqVo();
        imageVo.setImageType(CommonConstant.IMAGE_TYPE_CENTER_DISPLAY);
        imageVo.setImageStatus(CommonConstant.IMAGE_STATUS_ENABLE);
        loadRes.setImageList(imageDao.loadList(imageVo, ImageVo.class));
        //标题加载
        List<CenterDisplayLoadResVo> loadTypeList = centerDisplayDao.loadByType(req);
        loadRes.setContent(loadTypeList.get(0).getContent());
        for (CenterDisplayLoadResVo centerDisplayLoadResVo : loadTypeList) {
            CenterDisplayReqVo reqVo = new CenterDisplayReqVo();
            reqVo.setContentType(centerDisplayLoadResVo.getContentType());
            List<FloorAreaResVo> list = centerDisplayDao.loadFloorAreaList(reqVo);
            centerDisplayLoadResVo.setList(list);
        }
        loadRes.setLoadTypeList(loadTypeList);
        return loadRes;
    }
}
