package com.tcm.common.web;

import com.tcm.common.service.AreaService;
import com.tcm.util.area.req.FloorAreaReqVo;
import com.tcm.util.area.req.FloorLoadPageReqVo;
import com.tcm.util.area.req.FloorReqVo;
import com.tcm.util.area.res.FloorAreaResVo;
import com.tcm.util.area.res.FloorResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/area")
public class AreaController {

    private final AreaService areaService;

    public AreaController(AreaService areaService) {
        this.areaService = areaService;
    }

    /**
     * 区域新增
     */
    @RequestMapping("/floorSave")
    public ResponseResult<String> floorSave(@RequestBody FloorReqVo req) {
        return ResponseResult.result(areaService.floorSave(req));

    }

    /**
     * 区域加载
     */
    @RequestMapping("/floorLoad")
    public ResponseResult<FloorResVo> floorLoad(@RequestBody FloorReqVo req) {
        return ResponseResult.result(areaService.floorLoad(req));

    }

    /**
     * 区域分页查询
     */
    @RequestMapping("/loadPage")
    public ResponseResult<PageSizeData<FloorResVo>> loadPage(@RequestBody FloorLoadPageReqVo req) {
        return ResponseResult.result(areaService.loadPage(req));

    }

    /**
     * 区域删除
     */
    @RequestMapping("/floorRemove")
    public ResponseResult<String> floorRemove(@RequestBody FloorReqVo req) {
        return ResponseResult.result(areaService.floorRemove(req));

    }

    /**
     * 区域加载
     */
    @RequestMapping("/areaLoad")
    public ResponseResult<FloorAreaResVo> areaLoad(@RequestBody FloorAreaReqVo req) {
        return ResponseResult.result(areaService.areaLoad(req));

    }

    /**
     * 区域保存
     */
    @RequestMapping("/areaSave")
    public ResponseResult<String> areaSave(@RequestBody FloorAreaReqVo req) {
        return ResponseResult.result(areaService.areaSave(req));

    }

    /**
     * 区域删除
     */
    @RequestMapping("/areaRemove")
    public ResponseResult<String> areaRemove(@RequestBody FloorAreaReqVo req) {
        return ResponseResult.result(areaService.areaRemove(req));

    }
}
