package com.tcm.common.web;

import com.tcm.common.service.CenterDisplayService;
import com.tcm.util.area.req.CenterDisplayReqVo;
import com.tcm.util.area.res.CenterDisplayHomeLoadResVo;
import com.tcm.util.area.res.CenterDisplayResVo;
import com.tcm.util.common.req.TcmEnumReqVo;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/centerDisplay")
public class CenterDisplayController {


    private final CenterDisplayService centerDisplayService;

    public CenterDisplayController(CenterDisplayService centerDisplayService) {
        this.centerDisplayService = centerDisplayService;
    }


    /**
     * 展示区新增
     */
    @RequestMapping("/save")
    public ResponseResult<String> save(@RequestBody CenterDisplayReqVo req) {
        return ResponseResult.result(centerDisplayService.save(req));

    }

    /**
     * 展示区加载
     */
    @RequestMapping("/load")
    public ResponseResult<CenterDisplayResVo> load(@RequestBody CenterDisplayReqVo req) {
        return ResponseResult.result(centerDisplayService.load(req));

    }

    /**
     * 展示区列表
     */
    @RequestMapping("/loadList")
    public ResponseResult<List<CenterDisplayResVo>> loadList(@RequestBody CenterDisplayReqVo req) {
        return ResponseResult.result(centerDisplayService.loadList(req));

    }

    /**
     * 展示区删除
     */
    @RequestMapping("/remove")
    public ResponseResult<String> remove(@RequestBody TcmEnumReqVo req) {
        return ResponseResult.result(centerDisplayService.remove(req));

    }

    /**
     * 中心展区加载
     */
    @RequestMapping("/loadCenter")
    public ResponseResult<CenterDisplayHomeLoadResVo> loadCenter(@RequestBody CenterDisplayReqVo req) {
        return ResponseResult.result(centerDisplayService.loadCenter(req));

    }

}



