package com.tcm.product.service.impl;

import com.tcm.product.dao.ProductCategoryDao;
import com.tcm.product.dao.ProductDao;
import com.tcm.product.dao.ProductExtendDao;
import com.tcm.product.service.ProductService;
import com.tcm.util.product.ProductExtendVo;
import com.tcm.util.product.ProductVo;
import com.tcm.util.product.req.ProductLoadPageReqVo;
import com.tcm.util.product.req.ProductReqVo;
import com.tcm.util.product.res.ProductCategoryResVo;
import com.tcm.util.product.res.ProductResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.MapHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
public class ProductServiceImpl implements ProductService {

    private final ProductDao productDao;
    private final ProductExtendDao productExtendDao;
    private final ProductCategoryDao productCategoryDao;

    public ProductServiceImpl(ProductDao productDao,
                              ProductExtendDao productExtendDao,
                              ProductCategoryDao productCategoryDao) {
        this.productDao = productDao;
        this.productExtendDao = productExtendDao;
        this.productCategoryDao = productCategoryDao;
    }


    @Override
    public String save(ProductReqVo req) {
        if (StringHelper.isEmpty(req.getProductId())) {
            //新增
            ProductVo productVo = new ProductVo();
            ObjectHelper.writeWithFrom(productVo, req);
            String productId = StringHelper.getNewID();
            productVo.setProductId(productId);
            productVo.setCreateTime(DateHelper.getNow());
            productDao.save(productVo);

            ProductExtendVo productExtendVo = new ProductExtendVo();
            ObjectHelper.writeWithFrom(productExtendVo, req.getProductExtendVo());
            productExtendVo.setProductId(productId);
            productExtendVo.setProductExtendId(StringHelper.getNewID());
            productExtendVo.setCreateTime(DateHelper.getNow());
            productExtendDao.save(productExtendVo);
            return productId;
        } else {
            ProductVo productVo = new ProductVo();
            productVo.setProductId(req.getProductId());
            ProductVo load = productDao.load(productVo, ProductVo.class);
            ObjectHelper.writeWithFrom(load, req);
            load.setUpdateTime(DateHelper.getNow());
            productDao.update(load);
            ProductExtendVo productExtendVo = new ProductExtendVo();
            productExtendVo.setProductId(req.getProductId());
            ProductExtendVo loadExtend = productExtendDao.load(productExtendVo, ProductExtendVo.class);
            ObjectHelper.writeWithFrom(loadExtend, req.getProductExtendVo());
            loadExtend.setUpdateTime(DateHelper.getNow());
            productExtendDao.update(productExtendVo);
            return req.getProductId();
        }

    }

    @Override
    public ProductResVo load(ProductReqVo req) {
        ProductVo productVo = new ProductVo();
        productVo.setProductId(req.getProductId());
        ProductResVo loadRes = productDao.load(productVo, ProductResVo.class);
        ProductExtendVo productExtendVo = new ProductExtendVo();
        productExtendVo.setProductId(req.getProductId());
        ProductExtendVo loadExtend = productExtendDao.load(productExtendVo, ProductExtendVo.class);
        loadRes.setProductExtendVo(loadExtend);
        return loadRes;
    }

    @Override
    public PageSizeData<ProductResVo> loadPage(ProductLoadPageReqVo req) {
        PageSizeData<ProductResVo> page = productDao.loadPage(req, ProductResVo.class);
        ProductExtendVo productExtendVo = new ProductExtendVo();
        for (ProductResVo res : page.getList()) {
            productExtendVo.setProductId(res.getProductId());
            ProductExtendVo loadExtend = productExtendDao.load(productExtendVo, ProductExtendVo.class);
            res.setProductExtendVo(loadExtend);
        }
        return page;
    }

    @Override
    public String remove(ProductReqVo req) {
        ProductVo productVo = new ProductVo();
        productVo.setProductId(req.getProductId());
        productDao.remove(productVo);
        ProductExtendVo productExtendVo = new ProductExtendVo();
        productExtendVo.setProductId(req.getProductId());
        productExtendDao.remove(productExtendVo);
        return req.getProductId();
    }

    @Override
    public PageSizeData<ProductResVo> displayList(ProductLoadPageReqVo req) {
        PageSizeData<ProductResVo> page = productDao.loadPage(req, ProductResVo.class);
        List<ProductExtendVo> productExtendList = productExtendDao.loadList(req, ProductExtendVo.class);
        Map<String, ProductExtendVo> productExtendVoMap = MapHelper.getMap(productExtendList, ProductExtendVo::getProductId);
        page.getList().forEach(item -> {
            item.setProductExtendVo(productExtendVoMap.get(item.getProductId()));
        });
        return null;
    }
}
