package com.tcm.product.web;

import com.tcm.product.service.ProductService;
import com.tcm.util.product.req.ProductLoadPageReqVo;
import com.tcm.util.product.req.ProductReqVo;
import com.tcm.util.product.res.ProductResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/product")
public class ProductController {


    private final ProductService productService;

    public ProductController(ProductService productService) {
        this.productService = productService;
    }

    /**
     * 产品新增
     */
    @RequestMapping("/save")
    public ResponseResult<String> save(@RequestBody ProductReqVo req) {
        return ResponseResult.result(productService.save(req));

    }

    /**
     * 产品加载
     */
    @RequestMapping("/load")
    public ResponseResult<ProductResVo> load(@RequestBody ProductReqVo req) {
        return ResponseResult.result(productService.load(req));

    }

    /**
     * 产品分页查询
     */
    @RequestMapping("/loadPage")
    public ResponseResult<PageSizeData<ProductResVo>> loadPage(@RequestBody ProductLoadPageReqVo req) {
        return ResponseResult.result(productService.loadPage(req));

    }

    /**
     * 产品删除
     */
    @RequestMapping("/remove")
    public ResponseResult<String> remove(@RequestBody ProductReqVo req) {
        return ResponseResult.result(productService.remove(req));

    }

    /**
     * 客户端展示产品
     */
    @RequestMapping("/displayList")
    public ResponseResult<PageSizeData<ProductResVo>> displayList(@RequestBody ProductLoadPageReqVo req) {
        return ResponseResult.result(productService.displayList(req));

    }
}
