package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.FinanceService;
import com.pangding.web.authority.vo.reqvo.WithdrawalReqVo;
import com.pangding.web.authority.vo.resvo.WithdrawalResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/6/18 19:53
 */
@RestController
@RequestMapping(value = "/finance",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class FinanceController {
    @Autowired
    private FinanceService financeServiceImpl;

    @PostMapping(value = "/withdrawal")
    public ResponseResult<WithdrawalResVo> withdrawal(@RequestBody WithdrawalReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getCompanyId())
                .checkException();
        return ResponseResult.result(financeServiceImpl.withdrawal(reqVo));
    }

    @PostMapping(value = "/test")
    public List<List<Integer>> combinationSum(int[] candidates, int target) {
        List<List<Integer>> resList = new ArrayList<>();
        for (int i = 0; i < candidates.length; i++) {
            List<Integer> list = method(candidates,target);
            resList.add(list);
        }
        return resList;
    }
    private List<Integer> method(int[] candidates, int target){
        List<Integer> list = new ArrayList<>();
        for (int i = 0; i < candidates.length; i++) {
            int res = target - candidates[i];
            if (res < 0){
                continue;
            }else if (res == 0){
                list.add(candidates[i]);
            }else {
                list.add(candidates[i]);
                List<Integer> nextList = method(candidates,res);
                list.addAll(nextList);
            }
        }
        return list;
    }
}
