package com.pangding.web.authority.service;

import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.*;
import com.pangding.web.authority.vo.resvo.WebUserResVo;
import com.pangding.web.vo.system.pd.authority.RoleVo;
import com.pangding.web.vo.system.pd.authority.UserVo;
import com.pangding.web.vo.system.req.authority.SaveUserReqVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface UserService {

    /**
     * 保存用户信息，并保存用户和角色的对应关系
     *
     * @param userDto UserDto对象
     */
    String saveUser(WebUserReqVo userDto) throws Exception;

    /**
     * 保存更新后的用户信息，并更新用户和角色的对应关系
     *
     * @param userDto UserDto对象
     */
    String updateUser(WebUserReqVo userDto);

    /**
     * 检查用户名是否存在
     *
     * @param userVo UserVo对象
     */
    void checkAccount(UserVo userVo);

    /**
     * 检查电话号码是否存在
     *
     * @param userVo UserVo对象
     */
    void checkPhone(UserVo userVo);

    /**
     * 对密码进行MD5盐值加密
     *
     * @param password 密码
     * @return 加密后的密码
     */
    String passwordEncoder(String password);


    /**
     * 将UserVo对象添加角色id列表和角色名列表封装成UserDto对象
     *
     * @param userVo UserVo对象
     * @return UserDto对象
     */
    WebUserResVo makeResVo(UserVo userVo);

    /**
     * 通过用户id查询UserVo对象
     *
     * @param userId 用户id
     * @return UserVo对象
     */
    WebUserResVo getUserById(String userId);

    /**
     * 获取用户分页对象
     *
     * @param reqVo
     * @return 用户分页对象
     */
    PageSizeData<UserVo> getUserVoList(ListUserReqVo reqVo);

    /**
     * 获取用户返回信息分页对象
     *
     * @param reqVo
     * @return 用户返回信息分页对象
     */
    PageSizeData<WebUserResVo> getWebUserResVoList(ListUserReqVo reqVo);

    /**
     * 通过userId查询user和role对应关系对象列表
     *
     * @param reqVo GetUserRoleListByUserIdReqVo对象
     * @return UserRole对应关系对象列表
     */
    List<UserRoleVo> listUserRoleListByUserId(UserRoleGetReqVo reqVo);

    /**
     * 根据roleId查询RoleVo对象
     *
     * @param roleGetReqVo GetRoleByRoleIdReqVo对象
     * @return RoleVo对象
     */
    RoleVo getRoleByRoleId(RoleGetReqVo roleGetReqVo);

    /**
     * 检查用户名是否合法
     *
     * @param account 用户名
     * @return
     */
    void isValid(String account);

    /**
     * 检查是否为纯数字，用来判断输入的是用户名还是手机号
     *
     * @param account 用户名
     * @return
     */
    Boolean isNumeric(String account);

    /**
     * 通过电话号码获取用户信息
     *
     * @param phone 电话号码
     * @return UserVo对象
     */
    UserVo getUserByPhone(String phone);

    /**
     * 通过用户名获取用户信息
     *
     * @param account 用户名
     * @return UserVo对象
     */
    UserVo getUserByAccount(String account);

    /**
     * 根据用户id获取角色列表
     *
     * @param userId 用户id
     * @return 角色列表
     */
    List<RoleVo> getRoleListByUserId(String userId);

    void checkEmail(String email);


    /**
     * 用户注册（新tangfang）
     * @param saveUserReqVo
     * @return
     */
    ResponseResult<String> registerSaveUser(SaveUserReqVo saveUserReqVo);
}
