package com.pangding.web.authority.feign;

import com.pangding.web.authority.vo.reqvo.CompanySaveReqVo;
import com.pangding.web.vo.system.req.DeviceReqVo;
import com.pangding.web.vo.system.req.company.CompanyBankCardReqVo;
import com.pangding.web.vo.system.req.company.SaveCompanyReqVo;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;

/**
 * @Author zhangjinyao
 * @create 2019/6/2 18:06
 */
@FeignClient(value="pd-interface-pay")
@RequestMapping(value="/userNew")
public interface PayFeign {
    /**
     * 注册会员
     * @param req
     * @return
     */
    @RequestMapping(value="/register")
    ResponseResult<CompanySaveReqVo> setCompanyInfo(@RequestBody CompanySaveReqVo req);

    @RequestMapping(value = "/setCompanyInfo", method = RequestMethod.POST)
    ResponseResult<SaveCompanyReqVo> setCompanyInfo1(@RequestBody SaveCompanyReqVo req);

    /**
     * 企业会员绑定对公户
     * @param req
     * @return
     */
    @RequestMapping(value = "/bindCompanyAccount", method = RequestMethod.POST)
    ResponseResult<CompanyBankCardReqVo> bindCompanyAccount(@RequestBody CompanyBankCardReqVo req);

    /**
     * 绑定银行卡
     * @param req
     * @return
     */
    @RequestMapping(value="/bindback")
    ResponseResult<CompanyBankCardReqVo> bindBack(@RequestBody CompanyBankCardReqVo req);

    /**
     * 解绑银行卡
     * @param req
     * @return
     */
    @RequestMapping(value = "/unbindBankCard")
    ResponseResult<CompanyBankCardReqVo> unbindBankCard(@RequestBody CompanyBankCardReqVo req);

    /**
     * 获取签约地址
     * @param req
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/sign")
    ResponseResult<CompanySaveReqVo> sign11(@RequestBody CompanySaveReqVo req) throws IOException;

    /**
     * 绑定设备编号
     * @param deviceReqVo
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/vspTermidService",  method = RequestMethod.POST)
    ResponseResult<Boolean> vspTermidService(@RequestBody DeviceReqVo deviceReqVo);

    /**
     * 上传证件相片
     * @param req
     * @return
     */
    @RequestMapping(value = "/uploadPic", method = RequestMethod.POST)
    ResponseResult<Boolean> idcardCollect(@RequestBody SaveCompanyReqVo req);

    @ResponseBody
    @RequestMapping(value = "/vspTermidInfoManage")
    @ApiOperation(value = "支付终端信息管理", notes = "支付终端信息管理")
    public ResponseResult<String> vspTermidInfoManage(@RequestBody DeviceReqVo req);

}
