package com.pangding.web.authority.service;


import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.resvo.SaveCompanyResVo;
import com.pangding.web.vo.system.pd.company.CompanyExtendVo;
import com.pangding.web.vo.system.pd.company.CompanyVo;
import com.pangding.web.vo.system.req.LoginReqVo;
import com.pangding.web.vo.system.res.LoginResVo;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.io.IOException;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:21
 */
public interface RegisterService {

    /**
     * 判断注册编码是否存在
     *
     * @param invitationCode 注册编码
     * @return 若不存在，返回null，存在则返回CompanyExtendVo对象
     */
    CompanyExtendVo checkInvitationCode(String invitationCode);

    /**
     * 保存用户信息，并返回公司信息
     *
     * @param registerUserReqVo
     * @return CompanyVo对象
     */
    CompanyVo saveUser(RegisterUserReqVo registerUserReqVo) throws Exception;

    /**
     * 保存个人注册的公司信息
     *
     * @param reqVo
     * @return 返回保存数据各表的主键
     */
    SaveCompanyResVo saveIndividual(RegisterIndividualReqVo reqVo);

    /**
     * 保存企业注册的公司信息
     *
     * @param reqVo
     * @return 返回保存数据各表的主键
     */
    SaveCompanyResVo saveEnterprice(RegisterEnterpriceReqVo reqVo);

    /**
     * 登陆，验证用户名或手机号，密码是否正确
     * 返回token,account,LoginCompanyResVo对象（id：公司id,status：公司状态,companyAttribute：属性,bankCardCodeList：绑定的银行卡数组）
     *
     * @param reqVo
     * @return
     */
    LoginResVo login(LoginReqVo reqVo) throws Exception;

    LoginResVo verifyLogin(ComputerLoginReqVo reqVo, HttpSession session, HttpServletRequest request) throws Exception;

    /**
     * 将通过公司id获取到的公司信息和验证码传到第三方，并将返回的信息用于更新公司状态
     * @param reqVo 封装了公司id和验证码的请求对象
     * @return
     */
    String individualSubmit(IndividualSubmitReqVo reqVo);

    /**
     * 将通过公司id获取到的公司信息和验证码传到第三方，并将返回的信息用于更新公司状态
     * @param reqVo 封装了公司id和验证码的请求对象
     * @return
     */
    String enterpriceSubmit(EnterpriceSubmitReqVo reqVo);

    String fileUpload(CommonsMultipartFile file) throws IOException;

    void businesslicenseCode(BusinessLicenseCodeReqVo reqVo);
}
