package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.dao.company.CompanyBankCardDao;
import com.pangding.web.authority.dao.company.CompanyDao;
import com.pangding.web.authority.dao.company.CompanyExtendDao;
import com.pangding.web.authority.feign.PayFeign;
import com.pangding.web.authority.feign.StoreFeign;
import com.pangding.web.authority.service.*;
import com.pangding.web.authority.util.*;
import com.pangding.web.authority.vo.code.CodeService;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.resvo.SaveCompanyResVo;
import com.pangding.web.constant.CompanyConstant;
import com.pangding.web.util.RSAUtils;
import com.pangding.web.vo.product.pd.merchant.MerchantVo;
import com.pangding.web.vo.system.pd.LoginTokenVo;
import com.pangding.web.vo.system.pd.authority.AuthorityVo;
import com.pangding.web.vo.system.pd.authority.UserVo;
import com.pangding.web.vo.system.pd.company.CompanyBankCardVo;
import com.pangding.web.vo.system.pd.company.CompanyExtendVo;
import com.pangding.web.vo.system.pd.company.CompanyVo;
import com.pangding.web.vo.system.req.LoginReqVo;
import com.pangding.web.vo.system.req.authority.UserReqVo;
import com.pangding.web.vo.system.req.company.UpdateCompanyMoneyReqVo;
import com.pangding.web.vo.system.res.LoginResVo;
import com.pangding.web.vo.system.res.authority.AuthorityListByLevelResVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.pangding.web.vo.system.res.company.LoginCompanyResVo;
import com.yanzuoguang.token.TokenHelper;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.JsonHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.util.*;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:23
 */

@Service
public class RegisterServiceImpl implements RegisterService {

    @Autowired
    CompanyDao companyDao;
    @Autowired
    UserDao userDao;
    @Autowired
    UserService userService;
    @Autowired
    CompanyExtendDao companyExtendDao;
    @Autowired
    CompanyBankCardDao companyBankCardDao;
    @Autowired
    UserRoleDao userRoleDao;
    @Autowired
    VerifyCodeService verifyCodeService;
    @Autowired
    RoleAuthorityDao roleAuthorityDao;
    @Autowired
    AuthorityDao authorityDao;
    @Autowired
    AuthorityService authorityService;
    @Autowired
    private PayFeign payFeign;
    @Autowired
    private StoreFeign storeFeign;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private CodeService codeService;

    /**
     * 判断注册编码是否存在
     *
     * @param invitationCode 注册编码
     * @return 若不存在，返回null，存在则返回CompanyExtendVo对象
     */
    @Override
    public CompanyExtendVo checkInvitationCode(String invitationCode) {
        CompanyExtendGetReqVo reqVo = new CompanyExtendGetReqVo();
        reqVo.setInvitationCode(invitationCode);
        CompanyExtendVo companyExtendVo = companyExtendDao.load(reqVo, CompanyExtendVo.class);
        return companyExtendVo;
    }

    /**
     * 保存用户信息，并返回公司信息
     *
     * @param registerUserReqVo
     * @return CompanyVo对象
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CompanyVo saveUser(RegisterUserReqVo registerUserReqVo) throws Exception {

        // 检查账户是否合法
        userService.isValid(registerUserReqVo.getAccount());

        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setAccount(registerUserReqVo.getAccount());
        // 检查用户名是否存在
        UserVo userVoCheck = userDao.load(userGetReqVo, UserVo.class);
        if (null != userVoCheck) {
            throw new CodeException("用户名" + registerUserReqVo.getAccount() + "已存在");
        }

        /*通过私钥将rsa加密的密码解密*/
        String password = RSAUtils.decryptionByPrivateKey(registerUserReqVo.getPassword(), RsaConstant.privateKey);
        String confirmPassword = RSAUtils.decryptionByPrivateKey(registerUserReqVo.getConfirmPassword(), RsaConstant.privateKey);

        if (!StringHelper.compare(password, confirmPassword)) {
            throw new CodeException("确认密码错误");
        }
        CompanyResVo companyExtendVo = companyService.findCompany(registerUserReqVo.getInvitationCode());
        if (StringHelper.isEmpty(companyExtendVo)) {
            throw new CodeException("注册编码错误");
        }
        // 判断邀请公司状态
        if(StringHelper.isEmpty(companyExtendVo.getInvitationStatus())){
            throw new CodeException("用户无邀请状态");
        }
        if( 0 == companyExtendVo.getInvitationStatus() || 1 != companyExtendVo.getExamineStatus()){
            throw new CodeException("用户邀请状态错误：" + companyExtendVo.getInvitationStatus() + ",状态错误：" + companyExtendVo.getExamineStatus());
        }
        // 判断该账户已经邀请的人数
        if(companyExtendVo.getInviteesPeople() <= companyExtendVo.getInvitedPeople()){
            throw new CodeException("邀请人数已超过可邀请人数，注册失败。可邀请人数为：" + companyExtendVo.getInviteesPeople());
        }
        // 添加用户邀请人数
        UpdateCompanyMoneyReqVo updateCompanyMoneyReqVo = new UpdateCompanyMoneyReqVo();
        updateCompanyMoneyReqVo.setCompanyId(companyExtendVo.getId());
        updateCompanyMoneyReqVo.setInvitedPeople(1);
        companyExtendDao.updateCompanyInvitedPeople(updateCompanyMoneyReqVo);

        /*保存用户*/
        UserVo userVo = new UserVo();
        userVo.setAccount(registerUserReqVo.getAccount());
        String companyId = StringHelper.getNewID();
        userVo.setPassword(StringHelper.md5(password));
        userVo.setId(StringHelper.getNewID());
        userVo.setRemark(password);
        userVo.setCompanyId(companyId);
        userVo.setIsFirst(1);
        userVo.setCreateTime(DateHelper.getNow());
        userDao.create(userVo);

        /*保存公司*/
        CompanyVo companyVo = new CompanyVo();
        companyVo.setId(companyId);
        companyVo.setInvitationCompanyId(companyExtendVo.getId());
        companyVo.setInvitationCompanyName(companyExtendVo.getCompanyName());
        companyVo.setCompanyType(registerUserReqVo.getCompanyType());
        companyVo.setExamineStatus(0);
        companyVo.setStatus(0);
        companyDao.create(companyVo);

        /*保存公司扩展表*/
        CompanyExtendVo extendVo = new CompanyExtendVo();
        extendVo.setId(companyVo.getId());
        String qrCode = DateHelper.getNow()
                .replace("-", "")
                .replace(":", "")
                .replace(" ", "");
        extendVo.setQrCode(qrCode);
        companyExtendDao.create(extendVo);

        return companyVo;
    }

    /**
     * 保存个人注册的公司信息
     *
     * @param reqVo
     * @return 返回保存数据各表的主键
     */
    @Override
    public SaveCompanyResVo saveIndividual(RegisterIndividualReqVo reqVo) {

//        CompanyVo companyVo1 = new CompanyVo();
//        companyVo1.setContactPhone(reqVo.getContactPhone());
//        CompanyVo companyVo2 = companyDaoImpl.load(companyVo1,CompanyVo.class);
//        if (null != companyVo2 && !reqVo.getId().equals(companyVo2.getId())){
//            throw new CodeException("该号码已存在");
//        }
        /*此处应该调用第三方接口传入companyVo发送手机验证码并更新公司状态*/
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(reqVo.getId());
        CompanyVo company = companyDao.load(companyGetReqVo, CompanyVo.class);
        if(StringHelper.isEmpty(company)){
            throw new CodeException("未找到公司信息");
        }
        /*此处应该调用第三方接口传入companyVo发送手机验证码并更新公司状态*/
        ObjectHelper.writeWithFrom(company, reqVo);
        CompanySaveReqVo companySaveReqVo = new CompanySaveReqVo();
        ObjectHelper.writeWithFrom(companySaveReqVo, reqVo);
        companySaveReqVo.setCompanyAttribution(reqVo.getCompanyAttribute());
        companySaveReqVo.setStatus(company.getStatus());
        ResponseResult result = payFeign.setCompanyInfo(companySaveReqVo);
        if (null == result || !"00".equals(result.getCode())) {
            throw new CodeException("保存商户失败，请重试");
        }
        CompanySaveReqVo resCompanySaveReqVo = (CompanySaveReqVo) result.getData();

        /*更新公司表*/
        CompanyVo companyVo = new CompanyVo();
        ObjectHelper.writeWithFrom(company, resCompanySaveReqVo);
        company.setProductOrInterface(CompanyConstant.PRODUCT);
        company.setExamineStatus(0);
        company.setCompanyAttribute(reqVo.getCompanyAttribute());
        companyDao.update(company);

        /*跟新用户表添加联系方式*/
        UserVo userReqVo = new UserVo();
        userReqVo.setCompanyId(reqVo.getId());
        UserVo userVo = userDao.load(userReqVo, UserVo.class);
        userVo.setPhone(reqVo.getContactPhone());
        userVo.setName(reqVo.getContactName());
        userDao.update(userVo);

        /*保存或更新商户表*/
        MerchantCreateReqVo req = new MerchantCreateReqVo();
        req.setId(StringHelper.getNewID());
        req.setName(reqVo.getCompanyName());
        req.setAddress(reqVo.getAddress());
        req.setType(reqVo.getCompanyAttribute());
        req.setProductCompanyId(reqVo.getId());
        req.setUserId(userVo.getId());
        req.setUsername(userVo.getAccount());
        req.setReqId(reqVo.getReqId());
        req.setPhone(reqVo.getContactPhone());
        req.setCreateTime(DateHelper.getNow());
        req.setProductCompanyName(reqVo.getCompanyName());
        if (null == reqVo.getMerchantId() || "".equals(reqVo.getMerchantId())) {
            req.setId(StringHelper.getNewID());
        } else {
            req.setId(reqVo.getMerchantId());
        }
        SaveCompanyResVo resVo = new SaveCompanyResVo();

        ResponseResult<MerchantVo> result1 = storeFeign.merchantCreate(req);
//        companyProducer.companyMerchantSave(req);

        if (result1.getCode().equals("00")) {
            String merchantId = result1.getData().getId();
            resVo.setMerchantId(merchantId);
        }

        resVo.setCompanyId(companyVo.getId());
        resVo.setCompanyExtendId(companyVo.getId());
        resVo.setUserId(userVo.getId());

        return resVo;
    }

    /**
     * 保存企业注册的公司信息
     *
     * @param reqVo
     * @return 返回保存数据各表的主键
     */
    @Override
    public SaveCompanyResVo saveEnterprice(RegisterEnterpriceReqVo reqVo) {

        /*此处应该调用第三方接口传入companyVo发送手机验证码并更新公司状态*/
        // 找到公司信息
        CompanyVo company = companyDao.load(reqVo.getId(), CompanyVo.class);
        if(StringHelper.isEmpty(company)){
            throw new CodeException("未找到公司信息");
        }
        // 初始化通联参数
        CompanySaveReqVo companySaveReqVo = new CompanySaveReqVo();
        ObjectHelper.writeWithFrom(companySaveReqVo, reqVo);
        companySaveReqVo.setCompanyAttribution(reqVo.getCompanyAttribute());
        companySaveReqVo.setStatus(company.getStatus());
        companySaveReqVo.setBankList(new ArrayList());
        CompanyBankReqVo1 companyBankReqVo1 = new CompanyBankReqVo1();
        ObjectHelper.writeWithFrom(companyBankReqVo1, reqVo);
        companyBankReqVo1.setId(StringHelper.getNewID());
        companySaveReqVo.getBankList().add(companyBankReqVo1);
        ResponseResult result = payFeign.setCompanyInfo(companySaveReqVo);
        if (null == result || !"00".equals(result.getCode())) {
            throw new CodeException("保存商户失败，请重试");
        }
        CompanySaveReqVo resCompanySaveReqVo = (CompanySaveReqVo) result.getData();

        /*更新公司表*/
        ObjectHelper.writeWithFrom(company, resCompanySaveReqVo);
        company.setProductOrInterface(CompanyConstant.PRODUCT);
        company.setExamineStatus(0);
        company.setCompanyAttribute(reqVo.getCompanyAttribute());
        companyDao.update(company);

        List<CompanyBankReqVo1> bankList = resCompanySaveReqVo.getBankList();
        if (null == bankList || bankList.isEmpty()) {
            throw new CodeException("保存商户失败，请重试");
        }

        /*保存银行卡，并将其设置为默认银行卡*/
        CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
        ObjectHelper.writeWithFrom(companyBankCardVo, bankList.get(0));
        companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
        companyBankCardVo.setReservedPhone(reqVo.getContactPhone());
        companyBankCardVo.setType(reqVo.getCompanyType());
        companyBankCardVo.setName(reqVo.getContactName());
        companyBankCardVo.setIdCard(reqVo.getContactCode());
        companyBankCardVo.setCompanyId(reqVo.getId());
        CompanyBankCardGetReqVo companyBankCardGetReqVo = new CompanyBankCardGetReqVo();
        companyBankCardGetReqVo.setCompanyId(reqVo.getId());
        companyBankCardGetReqVo.setBankCardCode(companyBankCardVo.getBankCardCode());
        CompanyBankCardVo companyBankCardVo1 = companyBankCardDao.load(companyBankCardGetReqVo, CompanyBankCardVo.class);
        if (null == companyBankCardVo1) {
            companyBankCardDao.create(companyBankCardVo);
        } else {
            companyBankCardVo.setId(companyBankCardVo1.getId());
            companyBankCardDao.update(companyBankCardVo);
        }


        /*保存公司扩展表*/
        CompanyExtendVo extendVo = new CompanyExtendVo();
        extendVo.setId(resCompanySaveReqVo.getId());
        String qrCode = DateHelper.getNow()
                .replace("-", "")
                .replace(":", "")
                .replace(" ", "");
        extendVo.setQrCode(qrCode);
        companyExtendDao.save(extendVo);

        SaveCompanyResVo resVo = new SaveCompanyResVo();



        /*更新用户信息，保存联系方式*/
        UserVo userReqVo = new UserVo();
        userReqVo.setCompanyId(reqVo.getId());
        UserVo userVo = userDao.load(userReqVo, UserVo.class);
        userVo.setPhone(reqVo.getContactPhone());
        userVo.setName(reqVo.getContactName());
        userDao.update(userVo);

        /*保存或更新商户表*/
        MerchantCreateReqVo req = new MerchantCreateReqVo();
//        req.setReqId(StringHelper.getNewID());
        req.setName(reqVo.getMerchantName());
        req.setType(reqVo.getCompanyAttribute());
        req.setProductCompanyId(reqVo.getId());
        req.setUserId(userVo.getId());
        req.setUsername(userVo.getAccount());
        if (null == reqVo.getMerchantId() || "".equals(reqVo.getMerchantId())) {
//            req.setId(StringHelper.getNewID());
        } else {
            req.setId(reqVo.getMerchantId());
        }
        if (null == reqVo.getMerchantAddress() || reqVo.getMerchantAddress().isEmpty()) {
            req.setAddress(reqVo.getAddress());
        } else {
            req.setAddress(reqVo.getMerchantAddress());
        }

        ResponseResult<MerchantVo> result1 = storeFeign.merchantCreate(req);
        if (result1.getCode().equals("00")) {
//            String merchantId = (String) result1.getData();
            String merchantId = result1.getData().getId();
            resVo.setMerchantId(merchantId);
        }

        resVo.setCompanyId(company.getId());
        resVo.setCompanyBankCardId(companyBankCardVo.getId());
        resVo.setCompanyExtendId(extendVo.getId());
        resVo.setUserId(userVo.getId());

        return resVo;
    }

    /**
     * 登陆，验证用户名或手机号，密码是否正确
     * 返回token,account,LoginCompanyResVo对象（id：公司id,status：公司状态,companyAttribute：属性,bankCardCodeList：绑定的银行卡数组）
     *
     * @param reqVo
     * @return
     */
    @Override
    public LoginResVo login(LoginReqVo reqVo) throws Exception {
        // 当输入用户名和密码时,检测验证码
        List<String> items = new ArrayList<>();
        items.add(reqVo.getAccountOrPhone());
        items.add(reqVo.getPassword());
        codeService.validate(reqVo.getCodeId(), reqVo.getCodeValue(), items);

        UserReqVo userReqVo = new UserReqVo();
        userReqVo.setLoginAccount(reqVo.getAccountOrPhone());
        UserVo userVo = userService.queryUser(userReqVo);
        if (StringHelper.isEmpty(userVo)) {
            throw new CodeException("用户名不存在");
        }
        /*通过私钥将rsa加密的密码解密*/
        String password = reqVo.getPassword();
//        if(StringHelper.isEmpty(reqVo.getLoginType()) || 2 != reqVo.getLoginType()){
            password = RSAUtils.decryptionByPrivateKey(reqVo.getPassword(), RsaConstant.privateKey);
//        }
        if (!(StringHelper.md5(password).equals(userVo.getPassword()))) {
            throw new CodeException("用户名或密码错误");
        }

        if (StringHelper.isEmpty(userVo.getCompanyId())) {
            throw new CodeException("用户信息有误，请联系管理员");
        }

        String token = TokenUtil.createToken(reqVo.getAccountOrPhone());

        // 登录返回参数
        LoginResVo resVo = new LoginResVo();
        resVo.setToken(token);
        userVo.setPassword("");
        userVo.setRemark("");
        resVo.setUserVo(userVo);

        // 保存登录token
        LoginTokenVo loginVo = new LoginTokenVo();
        loginVo.setToken(token);
        loginVo.setDataPwd(token);
        loginVo.setData(JsonHelper.serialize(reqVo));
        loginVo.setExpairTime(DateHelper.getNow());
        tokenService.save(loginVo);
        // 输出结果
        TokenHelper.write(token, loginVo);

        // 找到登录用户公司信息
        CompanyResVo companyVo = companyDao.load(userVo.getCompanyId(), CompanyResVo.class);
        if (StringHelper.isEmpty(companyVo)) {
            throw new CodeException("注册信息有误");
        }
        if(CompanyConstant.EXAMINE_STATUS_FAIL == companyVo.getExamineStatus()){
            throw new CodeException("公司未审核通过。" + companyVo.getExamineFailedReason());
        }
        if(CompanyConstant.EXAMINE_STATUS_STOP == companyVo.getExamineStatus()){
            throw new CodeException("公司已停用，如有疑问，请联系管理员。");
        }
        LoginCompanyResVo loginCompanyResVo = new LoginCompanyResVo();
        loginCompanyResVo.setCompanyVo(companyVo);
        reqVo.setToken(token);

        // 找到公司银行信息 todo  登录的时候是否需要银行卡列表
        CompanyBankCardGetReqVo getReqVo = new CompanyBankCardGetReqVo();
        getReqVo.setCompanyId(companyVo.getId());
        List<CompanyBankCardVo> companyBankCardVoList = companyBankCardDao.loadList(getReqVo, CompanyBankCardVo.class);
        getReqVo.setIsDefault(1);
        CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(getReqVo, CompanyBankCardVo.class);
        loginCompanyResVo.setCompanyBankCardVo(companyBankCardVo);
        resVo.setCompanyResVo(loginCompanyResVo);

        //获取商家信息 todo  登录的时候是否需要银行卡列表
        CompanyScenicInfoReqVo companyScenicInfoReqVo = new CompanyScenicInfoReqVo();
        companyScenicInfoReqVo.setReqId(StringHelper.getNewID());
        companyScenicInfoReqVo.setCompanyId(companyVo.getId());
        companyScenicInfoReqVo.setProductOrInterface(0);
        try {
            ResponseResult result = storeFeign.getCompanyScenicInfo(companyScenicInfoReqVo);
            MerchantVo merchant = (MerchantVo) result.getData();
            resVo.setMerchant(merchant);
        } catch (Exception e) {
            resVo.setMerchant(null);
        }

        // 判断基本信息是否完善，及状态是否为2，且为个人用户，若不完善则跳转个人完善页面
        if (companyVo.getStatus() < (CompanyConstant.COMPANY_STATUS_BIND_PHONE) && CompanyConstant.COMPANY_TYPE_PERSON == (companyVo.getCompanyType())) {
            resVo.setCode("01");
            resVo.setMsg("个人基本信息未完善，跳转个人完善页面");
            return resVo;
        }
        // 判断基本信息是否完善，及状态是否为2，且为公司用户，若不完善则跳转个人完善页面
        else if (companyVo.getStatus() < (CompanyConstant.COMPANY_STATUS_BIND_PHONE) && (CompanyConstant.COMPANY_TYPE_COMPANY == (companyVo.getCompanyType()))) {
            resVo.setCode("02");
            resVo.setMsg("公司基本信息未完善，跳转公司完善页面");
            return resVo;
        }
        /*获取用户权限列表*/
        RoleAuthorityGetReqVo roleAuthorityGetReqVo = new RoleAuthorityGetReqVo();
        roleAuthorityGetReqVo.setUserId(userVo.getId());
        roleAuthorityGetReqVo.setPlatformType(reqVo.getLoginType());
        List<AuthorityListByLevelResVo> roleAuthorityVoList = roleAuthorityDao.loadList(roleAuthorityGetReqVo, AuthorityListByLevelResVo.class);
        resVo.setAuthorityListByLevel(AuthorityServiceImpl.getChildList(roleAuthorityVoList, false));


        loginCompanyResVo.setBankCardVoList(companyBankCardVoList);
        resVo.setCompanyResVo(loginCompanyResVo);

        resVo.setCode("00");
        return resVo;
    }

    public List<AuthorityListByLevelResVo> getChildList(AuthorityVo authorityVo, List<String> authorityIds) {
        List<AuthorityListByLevelResVo> resVoList = new ArrayList<>();
        for (int i = 0; i < authorityIds.size(); i++) {
            AuthorityGetReqVo authorityGetReqVo = new AuthorityGetReqVo();
            authorityGetReqVo.setId(authorityIds.get(i));
            AuthorityVo authorityVo1 = authorityDao.load(authorityGetReqVo, AuthorityVo.class);
            if (!StringHelper.isEmpty(authorityVo1)) {
                if (authorityVo1.getPid().equals(authorityVo.getId())) {
                    List<String> authorityIdList = new ArrayList<>();
                    authorityIdList.addAll(authorityIds);
                    authorityIdList.remove(i);
                    AuthorityListByLevelResVo resVo = new AuthorityListByLevelResVo();
                    ObjectHelper.writeWithFrom(resVo, authorityVo1);
                    if (authorityIds.size() > 0) {
                        resVo.setChildList(getChildList(authorityVo1, authorityIdList));
                    }
                    resVoList.add(resVo);
                }
            } else {
                System.out.println("无该权限：" + authorityIds.get(i));
            }

        }
//        Collections.sort(resVoList);
        return resVoList;
    }

    @Override
    public LoginResVo verifyLogin(ComputerLoginReqVo reqVo, HttpSession session, HttpServletRequest request) throws Exception {
        verifyCodeService.validImage(reqVo.getVerifyCode(), session, request);
        LoginReqVo reqVo1 = new LoginReqVo();
        ObjectHelper.writeWithFrom(reqVo1, reqVo);
        return this.login(reqVo1);
    }

    /**
     * 将通过公司id获取到的公司信息和验证码传到第三方，并将返回的信息用于更新公司状态
     *
     * @param reqVo 封装了公司id和验证码的请求对象
     * @return
     */
    @Override
    public String individualSubmit(IndividualSubmitReqVo reqVo) {
        CompanyGetReqVo getReqVo = new CompanyGetReqVo();
        getReqVo.setId(reqVo.getId());
        CompanyVo companyVo = companyDao.load(getReqVo, CompanyVo.class);
        if(StringHelper.isEmpty(companyVo)){
            throw new CodeException("未找到公司信息");
        }
        /*此处应该将companyVo和verifyCode发送到第三方接口，返回的数据用于更新公司信息*/
        CompanySaveReqVo companySaveReqVo = new CompanySaveReqVo();
        ObjectHelper.writeWithFrom(companySaveReqVo, companyVo);
        companySaveReqVo.setValidateCode(reqVo.getVerifyCode());
        companySaveReqVo.setCompanyAttribution(companyVo.getCompanyAttribute());
        ResponseResult result = payFeign.setCompanyInfo(companySaveReqVo);
        if (null == result || !"00".equals(result.getCode())) {
            throw new CodeException("保存商户失败，请重试");
        }
        CompanySaveReqVo resCompanySaveReqVo = (CompanySaveReqVo) result.getData();

        /*更新公司表*/
        ObjectHelper.writeWithFrom(companyVo, resCompanySaveReqVo);
        companyVo.setProductOrInterface(CompanyConstant.PRODUCT);
        companyVo.setCompanyAttribute(companyVo.getCompanyAttribute());
        companyVo.setExamineStatus(0);
        companyDao.update(companyVo);
        return reqVo.getVerifyCode();
    }

    /**
     * 将通过公司id获取到的公司信息和验证码传到第三方，并将返回的信息用于更新公司状态
     *
     * @param reqVo 封装了公司id和验证码的请求对象
     * @return
     */
    @Override
    public String enterpriceSubmit(EnterpriceSubmitReqVo reqVo) {
        CompanyVo companyVo = companyDao.load(reqVo.getId(), CompanyVo.class);
        if(StringHelper.isEmpty(companyVo)){
            throw new CodeException("未找到公司信息");
        }
        /*此处应该调用第三方接口传入companyVo发送手机验证码并更新公司状态*/
        ObjectHelper.writeWithFrom(companyVo, reqVo);
        CompanySaveReqVo companySaveReqVo = new CompanySaveReqVo();
        ObjectHelper.writeWithFrom(companySaveReqVo, companyVo);
        companySaveReqVo.setValidateCode(reqVo.getVerifyCode());
        companySaveReqVo.setCompanyAttribution(companyVo.getCompanyAttribute());
        CompanyBankReqVo1 companyBankReqVo1 = new CompanyBankReqVo1();
        ObjectHelper.writeWithFrom(companyBankReqVo1, reqVo);
        companyBankReqVo1.setType(reqVo.getCompanyType());
        companyBankReqVo1.setCompanyId(reqVo.getId());
        companyBankReqVo1.setName(reqVo.getContactName());
        companyBankReqVo1.setIdCard(reqVo.getContactCode());
        companyBankReqVo1.setPhone(reqVo.getContactPhone());
        // 查询银行卡
        CompanyBankCardGetReqVo companyBankCardGetReqVo = new CompanyBankCardGetReqVo();
        companyBankCardGetReqVo.setBankCardCode(reqVo.getBankCardCode());
        CompanyBankCardVo sqlCompanyBankCardVo = companyBankCardDao.load(companyBankCardGetReqVo, CompanyBankCardVo.class);
        if(!StringHelper.isEmpty(sqlCompanyBankCardVo)){
            companyBankReqVo1.setStatus(sqlCompanyBankCardVo.getStatus());
            companyBankReqVo1.setId(sqlCompanyBankCardVo.getId());
        }else{
            companyBankReqVo1.setStatus(0);
            companyBankReqVo1.setId(StringHelper.getNewID());
        }
        companyBankReqVo1.setValidateCode(reqVo.getVerifyCode());
        companySaveReqVo.setBankList(new ArrayList<>());
        companySaveReqVo.getBankList().add(companyBankReqVo1);

        ResponseResult result = payFeign.setCompanyInfo(companySaveReqVo);
        if (null == result || !"00".equals(result.getCode())) {
            throw new CodeException("保存商户失败，请重试");
        }
        CompanySaveReqVo resCompanySaveReqVo = (CompanySaveReqVo) result.getData();

        /*更新公司表*/
        ObjectHelper.writeWithFrom(companyVo, resCompanySaveReqVo);
        companyVo.setProductOrInterface(CompanyConstant.PRODUCT);
        companyVo.setExamineStatus(0);
        companyVo.setCompanyAttribute(companyVo.getCompanyAttribute());
        companyDao.update(companyVo);

        List<CompanyBankReqVo1> bankList = resCompanySaveReqVo.getBankList();
        if (null == bankList || bankList.isEmpty()) {
            throw new CodeException("保存商户失败，请重试");
        }

        /*保存银行卡，并将其设置为默认银行卡*/
        CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
        ObjectHelper.writeWithFrom(companyBankCardVo, bankList.get(0));
        companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
        if (6 == companySaveReqVo.getStatus()) {
            companyBankCardVo.setStatus(1);
            companyBankCardVo.setBindingTime(
                    DateHelper.getNow()
                            .substring(0, 10)
                            .replace("-", ""));
        }
        companyBankCardVo.setType(resCompanySaveReqVo.getCompanyType());
        companyBankCardVo.setCompanyId(resCompanySaveReqVo.getId());
        companyBankCardVo.setName(resCompanySaveReqVo.getContactName());
        companyBankCardVo.setIdCard(resCompanySaveReqVo.getContactCode());
        companyBankCardVo.setReservedPhone(resCompanySaveReqVo.getContactPhone());
        CompanyBankCardGetReqVo companyBankCardGetReqVo1 = new CompanyBankCardGetReqVo();
        companyBankCardGetReqVo1.setCompanyId(companyBankCardVo.getCompanyId());
        companyBankCardGetReqVo1.setBankCardCode(bankList.get(0).getBankCardCode());
        CompanyBankCardVo companyBankCardVo2 = companyBankCardDao.load(companyBankCardGetReqVo1, CompanyBankCardVo.class);
        if (null == companyBankCardVo2) {
            companyBankCardDao.create(companyBankCardVo);
        } else {
            companyBankCardVo.setId(companyBankCardVo2.getId());
            companyBankCardDao.update(companyBankCardVo);
        }
        return reqVo.getVerifyCode();
    }

    @Override
    public String fileUpload(CommonsMultipartFile file) throws IOException {
        String path = "C:/" + DateHelper.getNow() + file.getOriginalFilename();
        File newFile = new File(path);
        file.transferTo(newFile);
        return path;
    }

    @Override
    public void businesslicenseCode(BusinessLicenseCodeReqVo reqVo) {
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(reqVo.getCompanyId());
        CompanyVo companyVo = companyDao.load(companyGetReqVo, CompanyVo.class);
        if (null == companyVo) {
            throw new CodeException("未查询到该公司信息，请稍后重试");
        }
//        if(StringHelper.isEmpty(reqVo.getPicType())){
//            reqVo.setPicType(com.pangding.web.constant.CompanyConstant.PIC_TYPE);
//        }
//        if(com.pangding.web.constant.CompanyConstant.PIC_TYPE == reqVo.getPicType()){
//            companyVo.setUrl("http://picture.pangdly.com/" + reqVo.getUrl());
//        }
//        if(com.pangding.web.constant.CompanyConstant.USER_PHONE_FRONT == reqVo.getPicType()){
//            companyVo.setUserPhoneFront("http://picture.pangdly.com/" + reqVo.getUrl());
//        }
//        if(com.pangding.web.constant.CompanyConstant.USER_PHONE_BACK == reqVo.getPicType()){
//            companyVo.setUserPhoneBack("http://picture.pangdly.com/" + reqVo.getUrl());
//        }
//        if(com.pangding.web.constant.CompanyConstant.PIC_TYPE == reqVo.getPicType()){
        companyVo.setUrl(reqVo.getUrl());
//        }
//        if(com.pangding.web.constant.CompanyConstant.USER_PHONE_FRONT == reqVo.getPicType()){
//            companyVo.setUserPhoneFront(reqVo.getUrl());
//        }
//        if(com.pangding.web.constant.CompanyConstant.USER_PHONE_BACK == reqVo.getPicType()){
//            companyVo.setUserPhoneBack(reqVo.getUrl());
//        }
//        com.pangding.web.vo.system.req.company.OldSaveCompanyReqVo saveCompanyReqVo = new com.pangding.web.vo.system.req.company.OldSaveCompanyReqVo();
//        saveCompanyReqVo.setCompanyVo(companyVo);
//        saveCompanyReqVo.setPicType(reqVo.getPicType());
//        ResponseResult<Boolean> responseResult = payFeign.idcardCollect(saveCompanyReqVo);
//        if(responseResult.getData()){
        companyDao.update(companyVo);
//        }else{
//            throw new CodeException("图片上传失败");
//        }

    }
}
