package com.pangding.web.authority.vo.reqvo;

import com.pangding.web.vo.system.pd.company.CompanyInvitationRuleVo;
import com.pangding.web.vo.system.pd.company.CompanyRuleVo;
import com.pangding.web.vo.system.req.company.CompanyAgreementReqVo;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/7/17 16:46
 */
public class ExamineConfigReqVo {
    /**
     * 公司id
     */
    @ApiModelProperty(notes = "公司id")
    private String companyId;

    /**
     * 入口比例
     */
    @ApiModelProperty(notes = "入口比例")
    private Double sourceValue;

    /**
     * 实际入口比例
     */
    @ApiModelProperty(notes = "实际入口比例")
    private Double realSourceValue;

    /**
     * 入口比例说明
     */
    @ApiModelProperty(notes = "入口比例说明")
    private String sourceExplain;

    /**
     * 过境比例
     */
    @ApiModelProperty(notes = "过境比例")
    private Double passValue;

    /**
     * 实际过境比例
     */
    @ApiModelProperty(notes = "实际过境比例")
    private Double realPassValue;

    /**
     * 过境比例说明
     */
    @ApiModelProperty(notes = "过境比例说明")
    private String passExplain;

    /**
     * 上级比例
     */
    @ApiModelProperty(notes = "上级比例")
    private Double superValue;

    /**
     * 实际上级比例
     */
    @ApiModelProperty(notes = "实际上级比例")
    private Double realSuperValue;

    /**
     * 上级比例说明
     */
    @ApiModelProperty(notes = "上级比例说明")
    private String superExplain;

    @ApiModelProperty(notes = "手续费")
    private Double fee;
    @ApiModelProperty(notes = "税费")
    private Double taxFee;

    @ApiModelProperty(notes = "是否分账")
    private Integer subledgerStatus;

    @ApiModelProperty(notes = "分账规则 0 核销分账，1 购买分账，2过期自动分账")
    private Integer subledgerRule;

    @ApiModelProperty(notes = "核销时间 多少时间核销")
    private Integer subledgerRuleTime;

    @ApiModelProperty(notes = "是否分润 0不能分，1能分")
    private Integer divideStatus;

    @ApiModelProperty(notes = "是否能扫码支付")
    private Integer scanCodePayStatus;

    @ApiModelProperty(notes = "是否邀请(0不能邀请，1能邀请)")
    private Integer invitationStatus;
    @ApiModelProperty(notes = "邀请码")
    private String invitationCode;
    @ApiModelProperty(notes = "可邀请人数")
    private Integer inviteesPeople;
    @ApiModelProperty(notes = "激活状态 0 未激活 1激活 2 停用")
    private Integer activationStatus;
    @ApiModelProperty(notes = "提现规则 (0自动 ,1手动)")
    private Integer withdrawRule;

    @ApiModelProperty(notes = "最小限额")
    private Double minWithdrawMoney;
    @ApiModelProperty(notes = "最大限额")
    private Double maxWithdrawMoney;

    @ApiModelProperty(notes = "是否有优惠 0 无 1有")
    private Integer discountRule;

    @ApiModelProperty(notes = "提现手续费")
    private Double withdrawFee;

    @ApiModelProperty(notes = "提现到账方式")
    private String withdrawType;

    @ApiModelProperty(notes = "用户星级")
    private Integer grade;

    @ApiModelProperty(notes = "服务费状态")
    private Integer serviceChargeStatus;
    @ApiModelProperty(notes = "服务费类型")
    private Integer serviceChargeType;
    @ApiModelProperty(notes = "服务费资金类型")
    private Integer serviceChargeMoneyType;
    @ApiModelProperty(notes = "服务费缴纳方式：0-预交，1-提现扣除，2-先交后用")
    private Integer serviceChargePayType;
    @ApiModelProperty(notes = "服务费")
    private Double serviceCharge;
    @ApiModelProperty(notes = "签约类型0-线上，1-线下")
    private Integer signingType;
    @ApiModelProperty(notes = "签约状态")
    private Integer signingStatus;
    @ApiModelProperty(notes = "签约时间")
    private String signingTime;

    /**
     * 二维码类型(0:关注;1:付款;2:源码)
     */
    @ApiModelProperty(notes = "二维码类型(0:关注;1:付款;2:源码)")
    private Integer qrCodeType;

    /**
     * 0:未审核;1:审核通过,2审核不通过,3停用
     */
    @ApiModelProperty(notes = "0:未审核;1:审核通过,2审核不通过,3停用")
    private Integer examineStatus;

    /**
     * 审核失败原因
     */
    @ApiModelProperty(notes = "审核失败原因")
    private String examineFailedReason;

    @ApiModelProperty(notes = "到期日期")
    private String expirationDate;

    /**
     * 给该用户分配的角色id
     */
    @ApiModelProperty(notes = "给该用户分配的角色id")
    private String roleId;

    /**
     * 用户id
     */
    @ApiModelProperty(notes = "用户id")
    private String userId;
    @ApiModelProperty(notes = "公司提现规则")
    private List<CompanyRuleVo> companyRuleVoList;

    @ApiModelProperty(notes = "公司邀请规则")
    private List<CompanyInvitationRuleVo> companyInvitationActivatRuleVoList;

    @ApiModelProperty(notes = "公司邀请规则")
    private List<CompanyInvitationRuleVo> companyInvitationRewardRuleVoList;
    @ApiModelProperty(notes = "签约信息")
    private CompanyAgreementReqVo companyAgreementReqVo;

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public Double getSourceValue() {
        return sourceValue;
    }

    public void setSourceValue(Double sourceValue) {
        this.sourceValue = sourceValue;
    }

    public Double getRealSourceValue() {
        return realSourceValue;
    }

    public void setRealSourceValue(Double realSourceValue) {
        this.realSourceValue = realSourceValue;
    }

    public String getSourceExplain() {
        return sourceExplain;
    }

    public void setSourceExplain(String sourceExplain) {
        this.sourceExplain = sourceExplain;
    }

    public Double getPassValue() {
        return passValue;
    }

    public void setPassValue(Double passValue) {
        this.passValue = passValue;
    }

    public Double getRealPassValue() {
        return realPassValue;
    }

    public void setRealPassValue(Double realPassValue) {
        this.realPassValue = realPassValue;
    }

    public String getPassExplain() {
        return passExplain;
    }

    public void setPassExplain(String passExplain) {
        this.passExplain = passExplain;
    }

    public Double getSuperValue() {
        return superValue;
    }

    public void setSuperValue(Double superValue) {
        this.superValue = superValue;
    }

    public Double getRealSuperValue() {
        return realSuperValue;
    }

    public void setRealSuperValue(Double realSuperValue) {
        this.realSuperValue = realSuperValue;
    }

    public String getSuperExplain() {
        return superExplain;
    }

    public void setSuperExplain(String superExplain) {
        this.superExplain = superExplain;
    }

    public Integer getSubledgerStatus() {
        return subledgerStatus;
    }

    public void setSubledgerStatus(Integer subledgerStatus) {
        this.subledgerStatus = subledgerStatus;
    }

    public Integer getSubledgerRule() {
        return subledgerRule;
    }

    public void setSubledgerRule(Integer subledgerRule) {
        this.subledgerRule = subledgerRule;
    }

    public Integer getSubledgerRuleTime() {
        return subledgerRuleTime;
    }

    public void setSubledgerRuleTime(Integer subledgerRuleTime) {
        this.subledgerRuleTime = subledgerRuleTime;
    }

    public Integer getDivideStatus() {
        return divideStatus;
    }

    public void setDivideStatus(Integer divideStatus) {
        this.divideStatus = divideStatus;
    }

    public Integer getScanCodePayStatus() {
        return scanCodePayStatus;
    }

    public void setScanCodePayStatus(Integer scanCodePayStatus) {
        this.scanCodePayStatus = scanCodePayStatus;
    }

    public Integer getInvitationStatus() {
        return invitationStatus;
    }

    public void setInvitationStatus(Integer invitationStatus) {
        this.invitationStatus = invitationStatus;
    }

    public String getInvitationCode() {
        return invitationCode;
    }

    public void setInvitationCode(String invitationCode) {
        this.invitationCode = invitationCode;
    }

    public Integer getInviteesPeople() {
        return inviteesPeople;
    }

    public void setInviteesPeople(Integer inviteesPeople) {
        this.inviteesPeople = inviteesPeople;
    }

    public Integer getActivationStatus() {
        return activationStatus;
    }

    public void setActivationStatus(Integer activationStatus) {
        this.activationStatus = activationStatus;
    }

    public Integer getWithdrawRule() {
        return withdrawRule;
    }

    public void setWithdrawRule(Integer withdrawRule) {
        this.withdrawRule = withdrawRule;
    }

    public Double getMinWithdrawMoney() {
        return minWithdrawMoney;
    }

    public void setMinWithdrawMoney(Double minWithdrawMoney) {
        this.minWithdrawMoney = minWithdrawMoney;
    }

    public Double getMaxWithdrawMoney() {
        return maxWithdrawMoney;
    }

    public void setMaxWithdrawMoney(Double maxWithdrawMoney) {
        this.maxWithdrawMoney = maxWithdrawMoney;
    }

    public Integer getDiscountRule() {
        return discountRule;
    }

    public void setDiscountRule(Integer discountRule) {
        this.discountRule = discountRule;
    }

    public Double getWithdrawFee() {
        return withdrawFee;
    }

    public void setWithdrawFee(Double withdrawFee) {
        this.withdrawFee = withdrawFee;
    }

    public String getWithdrawType() {
        return withdrawType;
    }

    public void setWithdrawType(String withdrawType) {
        this.withdrawType = withdrawType;
    }

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public Integer getQrCodeType() {
        return qrCodeType;
    }

    public void setQrCodeType(Integer qrCodeType) {
        this.qrCodeType = qrCodeType;
    }

    public Integer getExamineStatus() {
        return examineStatus;
    }

    public void setExamineStatus(Integer examineStatus) {
        this.examineStatus = examineStatus;
    }

    public String getExamineFailedReason() {
        return examineFailedReason;
    }

    public void setExamineFailedReason(String examineFailedReason) {
        this.examineFailedReason = examineFailedReason;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public List<CompanyRuleVo> getCompanyRuleVoList() {
        return companyRuleVoList;
    }

    public void setCompanyRuleVoList(List<CompanyRuleVo> companyRuleVoList) {
        this.companyRuleVoList = companyRuleVoList;
    }

    public List<CompanyInvitationRuleVo> getCompanyInvitationActivatRuleVoList() {
        return companyInvitationActivatRuleVoList;
    }

    public void setCompanyInvitationActivatRuleVoList(List<CompanyInvitationRuleVo> companyInvitationActivatRuleVoList) {
        this.companyInvitationActivatRuleVoList = companyInvitationActivatRuleVoList;
    }

    public List<CompanyInvitationRuleVo> getCompanyInvitationRewardRuleVoList() {
        return companyInvitationRewardRuleVoList;
    }

    public void setCompanyInvitationRewardRuleVoList(List<CompanyInvitationRuleVo> companyInvitationRewardRuleVoList) {
        this.companyInvitationRewardRuleVoList = companyInvitationRewardRuleVoList;
    }

    public Double getFee() {
        return fee;
    }

    public void setFee(Double fee) {
        this.fee = fee;
    }

    public Double getTaxFee() {
        return taxFee;
    }

    public void setTaxFee(Double taxFee) {
        this.taxFee = taxFee;
    }

    public Integer getServiceChargeStatus() {
        return serviceChargeStatus;
    }

    public void setServiceChargeStatus(Integer serviceChargeStatus) {
        this.serviceChargeStatus = serviceChargeStatus;
    }

    public Integer getServiceChargeType() {
        return serviceChargeType;
    }

    public void setServiceChargeType(Integer serviceChargeType) {
        this.serviceChargeType = serviceChargeType;
    }

    public Double getServiceCharge() {
        return serviceCharge;
    }

    public void setServiceCharge(Double serviceCharge) {
        this.serviceCharge = serviceCharge;
    }

    public Integer getServiceChargeMoneyType() {
        return serviceChargeMoneyType;
    }

    public void setServiceChargeMoneyType(Integer serviceChargeMoneyType) {
        this.serviceChargeMoneyType = serviceChargeMoneyType;
    }

    public String getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Integer getServiceChargePayType() {
        return serviceChargePayType;
    }

    public void setServiceChargePayType(Integer serviceChargePayType) {
        this.serviceChargePayType = serviceChargePayType;
    }

    public Integer getSigningType() {
        return signingType;
    }

    public void setSigningType(Integer signingType) {
        this.signingType = signingType;
    }

    public Integer getSigningStatus() {
        return signingStatus;
    }

    public void setSigningStatus(Integer signingStatus) {
        this.signingStatus = signingStatus;
    }

    public String getSigningTime() {
        return signingTime;
    }

    public void setSigningTime(String signingTime) {
        this.signingTime = signingTime;
    }

    public CompanyAgreementReqVo getCompanyAgreementReqVo() {
        return companyAgreementReqVo;
    }

    public void setCompanyAgreementReqVo(CompanyAgreementReqVo companyAgreementReqVo) {
        this.companyAgreementReqVo = companyAgreementReqVo;
    }
}
