package com.pangding.web.authority.controller;

import com.pangding.web.authority.vo.cloudvo.LoginResVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.service.RegisterService;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.vo.CompanyVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author zhangjinyao
 * @create 2019/5/14 16:28
 */

@RestController
@RequestMapping(value="/computerRegister")
public class ComputerRegisterController {
    @Autowired
    RegisterService registerServiceImpl;
    @Autowired
    UserService userServiceImpl;

    /**
     * 验证注册第一页数据的合法性并保存在pd_user表中
     * 生成公司id，pd_company表中存入一条数据
     * 返回公司部分信息（id,invitationCompanyId,companyType），携带到基本信息页面
     *
     * @param registerUserReqVo
     * @return
     */
    @RequestMapping(value = "/user", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<CompanyVo> saveUser(@RequestBody RegisterUserReqVo registerUserReqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("account",registerUserReqVo.getAccount())
                .notBlankCheck("password",registerUserReqVo.getPassword())
                .notBlankCheck("confirmPassword",registerUserReqVo.getConfirmPassword())
                .notBlankCheck("companyType",registerUserReqVo.getCompanyType())
                .notBlankCheck("invitationCode",registerUserReqVo.getInvitationCode())
                .checkException();
        return ResponseResult.result(registerServiceImpl.saveUser(registerUserReqVo));
    }

    /**
     * 当用户类型选择为“个体”时进入此方法
     * 验证注册第二页数据的合法性并保存，pd_company,pd_company_bank_card,pd_company_extend,pd_merchant都增加一条数据
     * 并将联系电话更新到pd_user表中
     * 返回pd_user,pd_company,pd_company_bank_card,pd_company_extend,pd_merchant表的主键
     *
     * @param reqVo
     * @return
     */
    @RequestMapping(value="/individual", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<SaveCompanyResVo> saveIndividual(@RequestBody RegisterIndividualReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("contactName",reqVo.getContactName())
                .notBlankCheck("contactCode",reqVo.getContactCode())
                .checkIdCard("contactCode",reqVo.getContactCode())
                .notBlankCheck("companyAttribute",reqVo.getCompanyAttribute())
                .notBlankCheck("companyName",reqVo.getCompanyName())
                .notBlankCheck("contactPhone",reqVo.getContactPhone())
                .checkPhoneNo("contactPhone",reqVo.getContactPhone())
                .checkException();
        return ResponseResult.result(registerServiceImpl.saveIndividual(reqVo));
    }

    /**
     * 当用户类型选择为“企业”时进入此方法
     * 验证注册第二页数据的合法性并保存，pd_company,pd_company_bank_card,pd_company_extend,pd_merchant都增加一条数据
     * 并将联系电话更新到pd_user表中
     * 返回pd_user,pd_company,pd_company_bank_card,pd_company_extend,pd_merchant表的主键
     * @param reqVo
     * @return
     */
    @RequestMapping(value="/enterprise", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<SaveCompanyResVo> saveEnterprise(@RequestBody RegisterEnterpriceReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyName",reqVo.getCompanyName())
                .notBlankCheck("companyAddress",reqVo.getAddress())
                .notBlankCheck("businessLicenseCode",reqVo.getBusinessLicenseCode())
                .notNumberCheck("businessLicenseCode",reqVo.getBusinessLicenseCode())
                .notBlankCheck("merchantName",reqVo.getMerchantName())
                .notBlankCheck("companyAttribute",reqVo.getCompanyAttribute())
                .notBlankCheck("contactName",reqVo.getContactName())
                .notBlankCheck("contactCode",reqVo.getContactCode())
                .checkIdCard("contactCode",reqVo.getContactCode())
                .notBlankCheck("contactPhone",reqVo.getContactPhone())
                .checkPhoneNo("contactPhone",reqVo.getContactPhone())
                .notBlankCheck("bankName",reqVo.getBankName())
                .notBlankCheck("bankCardCode",reqVo.getBankCardCode())
                .notNumberCheck("bankCardCode",reqVo.getBankCardCode())
                .notBlankCheck("bankAddress",reqVo.getBankAddress())
                .notBlankCheck("bankCode",reqVo.getBankCode())
                .notNumberCheck("bankCode",reqVo.getBankCode())
                .notBlankCheck("reservedPhone",reqVo.getReservedPhone())
                .checkPhoneNo("reservedPhone",reqVo.getReservedPhone())
                .checkException();
        return ResponseResult.result(registerServiceImpl.saveEnterprise(reqVo));
    }

    /**
     * 登陆，验证用户名或手机号，密码是否正确
     * 返回token,account,LoginCompanyResVo对象（id：公司id,status：公司状态,companyAttribute：属性,bankCardCodeList：绑定的银行卡数组）
     *
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/login", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<LoginResVo> login(@RequestBody LoginReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("account or phone",reqVo.getAccountOrPhone())
                .notBlankCheck("pass",reqVo.getPassword())
                .checkException();
        return ResponseResult.result(registerServiceImpl.login(reqVo));
    }


}
