package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.feign.StoreFeign;
import com.pangding.web.authority.service.CompanyService;
import com.pangding.web.authority.util.TokenUtil;
import com.pangding.web.authority.vo.*;
import com.pangding.web.authority.vo.cloudvo.LoginResVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.service.RegisterService;
import com.pangding.web.authority.service.UserService;
import com.yanzuoguang.token.TokenHelper;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:23
 */

@Service
public class RegisterServiceImpl implements RegisterService {

    @Autowired
    CompanyDao companyDaoImpl;
    @Autowired
    UserDao userDaoImpl;
    @Autowired
    UserService userServiceImpl;
    @Autowired
    CompanyExtendDao companyExtendDaoImpl;
    @Autowired
    CompanyBankCardDao companyBankCardDaoImpl;
    @Autowired
    UserRoleDao userRoleDaoImpl;
    @Autowired
    private StoreFeign storeFeign;
    @Autowired
    private CompanyService companyService;

    /**
     * 判断注册编码是否存在
     *
     * @param invitationCode 注册编码
     * @return 若不存在，返回null，存在则返回CompanyExtendVo对象
     */
    @Override
    public CompanyExtendVo checkInvitationCode(String invitationCode) {
        CompanyExtendGetReqVo reqVo = new CompanyExtendGetReqVo();
        reqVo.setInvitationCode(invitationCode);
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(reqVo,CompanyExtendVo.class);
        return companyExtendVo == null ? null : companyExtendVo;
    }

    /**
     * 保存用户信息，并返回公司信息
     *
     * @param registerUserReqVo
     * @return CompanyVo对象
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CompanyVo saveUser(RegisterUserReqVo registerUserReqVo) {

        // 检查账户是否合法
        userServiceImpl.isValid(registerUserReqVo.getAccount());

        UserVo userVo = new UserVo();
        userVo.setAccount(registerUserReqVo.getAccount());
        // 检查用户名是否存在
        userServiceImpl.checkAccount(userVo);

        if (!StringHelper.compare( registerUserReqVo.getPassword(), registerUserReqVo.getConfirmPassword())){
            throw new CodeException("确认密码错误");
        }

        CompanyExtendVo companyExtendVo = checkInvitationCode(registerUserReqVo.getInvitationCode());
        if (null == companyExtendVo){
            throw new CodeException("注册编码错误");
        }

        String companyId = StringHelper.getNewID();
        userVo.setPassword(StringHelper.md5(registerUserReqVo.getPassword()));
        userVo.setId(StringHelper.getNewID());
        userVo.setRemark(registerUserReqVo.getPassword());
        userVo.setCompanyId(companyId);
        userDaoImpl.create(userVo);
        CompanyVo companyVo = new CompanyVo();
        companyVo.setId(companyId);
        companyVo.setInvitationCompanyId(companyExtendVo.getId());
        companyVo.setCompanyType(registerUserReqVo.getCompanyType());
        companyDaoImpl.create(companyVo);
        return companyVo;
    }

    /**
     * 检查电话号码是否已存在
     *
     * @param contactPhone 联系电话
     */
    @Override
    public void checkPhone(String contactPhone) {
        CompanyVo companyVo = new CompanyVo();
        companyVo.setContactPhone(contactPhone);
        companyDaoImpl.checkPhone(companyVo);
    }

    /**
     * 保存个人注册的公司信息
     *
     * @param reqVo
     * @return 返回保存数据各表的主键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaveCompanyResVo saveIndividual(RegisterIndividualReqVo reqVo) {

        this.checkPhone(reqVo.getContactPhone());

        CompanyVo companyVo = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo,reqVo);
        companyDaoImpl.update(companyVo);

        CompanyExtendVo extendVo = new CompanyExtendVo();
        extendVo.setId(reqVo.getId());
        companyExtendDaoImpl.save(extendVo);

        CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
        companyBankCardVo.setCompanyId(reqVo.getId());
        companyBankCardVo.setId(StringHelper.getNewID());
        companyBankCardDaoImpl.save(companyBankCardVo);

        UserVo userReqVo = new UserVo();
        userReqVo.setCompanyId(reqVo.getId());
        UserVo userVo = userDaoImpl.load(userReqVo,UserVo.class);
        userVo.setPhone(reqVo.getContactPhone());
        userDaoImpl.update(userVo);

        MerchantCreateReqVo req=new MerchantCreateReqVo();
        req.setId(StringHelper.getNewID());
        req.setName(reqVo.getCompanyName());
        req.setAddress(reqVo.getAddress());
        req.setType(reqVo.getCompanyAttribute());
        req.setProductCompanyId(reqVo.getId());
        req.setUserId(userVo.getId());
        req.setUsername(userVo.getAccount());
        String merchantId = (String) storeFeign.merchantCreate(req).getData();

        SaveCompanyResVo resVo = new SaveCompanyResVo();
        resVo.setCompanyId(companyVo.getId());
        resVo.setCompanyBankCardId(companyBankCardVo.getId());
        resVo.setCompanyExtendId(extendVo.getId());
        resVo.setMerchantId(merchantId);
        resVo.setUserId(userVo.getId());

        return resVo;
    }

    /**
     * 保存企业注册的公司信息
     *
     * @param reqVo
     * @return 返回保存数据各表的主键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaveCompanyResVo saveEnterprise(RegisterEnterpriceReqVo reqVo) {

        this.checkPhone(reqVo.getContactPhone());

        CompanyVo companyVo = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo,reqVo);
        companyDaoImpl.update(companyVo);

        CompanyExtendVo extendVo = new CompanyExtendVo();
        extendVo.setId(reqVo.getId());
        companyExtendDaoImpl.save(extendVo);

        CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
        companyBankCardVo.setId(StringHelper.getNewID());
        companyBankCardVo.setCompanyId(reqVo.getId());
        companyBankCardVo.setBankName(reqVo.getBankName());
        companyBankCardVo.setBankCardCode(reqVo.getBankCardCode());
        companyBankCardVo.setBankAddress(reqVo.getBankAddress());
        companyBankCardVo.setBankCode(reqVo.getBankCode());
        companyBankCardVo.setReservedPhone(reqVo.getReservedPhone());
        companyBankCardDaoImpl.save(companyBankCardVo);

        UserVo userReqVo = new UserVo();
        userReqVo.setCompanyId(reqVo.getId());
        UserVo userVo = userDaoImpl.load(userReqVo,UserVo.class);
        userVo.setPhone(reqVo.getContactPhone());
        userDaoImpl.update(userVo);

        MerchantCreateReqVo req=new MerchantCreateReqVo();
        req.setId(StringHelper.getNewID());
        req.setName(reqVo.getCompanyName());
        req.setAddress(reqVo.getAddress());
        req.setType(reqVo.getCompanyAttribute());
        req.setProductCompanyId(reqVo.getId());
        req.setUserId(userVo.getId());
        req.setUsername(userVo.getAccount());
        String merchantId = (String) storeFeign.merchantCreate(req).getData();

        SaveCompanyResVo resVo = new SaveCompanyResVo();
        resVo.setCompanyId(companyVo.getId());
        resVo.setCompanyBankCardId(companyBankCardVo.getId());
        resVo.setCompanyExtendId(extendVo.getId());
        resVo.setMerchantId(merchantId);
        resVo.setUserId(userVo.getId());

        return resVo;
    }

    /**
     * 登陆，验证用户名或手机号，密码是否正确
     * 返回token,account,LoginCompanyResVo对象（id：公司id,status：公司状态,companyAttribute：属性,bankCardCodeList：绑定的银行卡数组）
     *
     * @param reqVo
     * @return
     */
    @Override
    public LoginResVo login(LoginReqVo reqVo) {
        String accountOrPhone = reqVo.getAccountOrPhone();
        UserVo userVo;
        if (userServiceImpl.isNumeric(accountOrPhone)){
            userVo = userServiceImpl.getUserByPhone(accountOrPhone);
        }else {
            userVo = userServiceImpl.getUserByAccount(accountOrPhone);
        }

        if (userVo == null){
            throw new CodeException("没有此用户");
        }

        if (!StringHelper.md5(reqVo.getPassword()).equals(userVo.getPassword())){
            throw new CodeException("用户名或密码错误");
        }

        String token = TokenUtil.createToken(reqVo.getAccountOrPhone());
        TokenHelper.write(token,reqVo);

        LoginResVo resVo = new LoginResVo();

        resVo.setToken(token);

        resVo.setAccount(userVo.getAccount());

        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(userVo.getCompanyId());
        CompanyVo companyVo = companyDaoImpl.load(companyGetReqVo,CompanyVo.class);

        LoginCompanyResVo loginCompanyResVo = new LoginCompanyResVo();
        loginCompanyResVo.setId(companyVo.getId());
        loginCompanyResVo.setStatus(companyVo.getStatus());
        loginCompanyResVo.setCompanyAttribute(companyVo.getCompanyAttribute());

        CompanyBankCardGetReqVo getReqVo = new CompanyBankCardGetReqVo();
        getReqVo.setCompanyId(companyVo.getId());
        List<CompanyBankCardVo> companyBankCardVoList = companyBankCardDaoImpl.loadList(getReqVo,CompanyBankCardVo.class);
        List<String> bankCardCodeList = new ArrayList();
        if (companyBankCardVoList != null && !companyBankCardVoList.isEmpty()){
            for (CompanyBankCardVo companyBankCardVo:companyBankCardVoList) {
                bankCardCodeList.add(companyBankCardVo.getBankCardCode());
            }
        }
        loginCompanyResVo.setBankCardCodeList(bankCardCodeList);

        resVo.setCompanyResVo(loginCompanyResVo);

        return resVo;
    }
}
