package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.CompanyAgreementDao;
import com.pangding.web.authority.service.CompanyAgreementService;
import com.pangding.web.vo.system.pd.company.CompanyAgreementVo;
import com.pangding.web.vo.system.req.company.CompanyAgreementReqVo;
import com.pangding.web.vo.system.res.company.CompanyAgreementResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompanyAgreementServiceImpl implements CompanyAgreementService {

    @Autowired
    private CompanyAgreementDao companyAgreementDao;

    @Override
    public CompanyAgreementResVo checkAgreement(CompanyAgreementReqVo req) {
        CompanyAgreementResVo companyAgreementResVo = companyAgreementDao.load(req, CompanyAgreementResVo.class);
        return companyAgreementResVo;
    }

    @Override
    public CompanyAgreementVo saveCompanyAgreement(CompanyAgreementReqVo req) {
        String id = StringHelper.getMD5Id(req.getCompanyId(), req.getAgreementCode());
        CompanyAgreementVo companyAgreementVo = companyAgreementDao.load(id, CompanyAgreementVo.class);
        if (!StringHelper.isEmpty(companyAgreementVo)) {
            throw new CodeException("已签署合同");
        }
        companyAgreementVo = new CompanyAgreementVo();
        ObjectHelper.writeWithFrom(companyAgreementVo, req);
        companyAgreementVo.setCompanyAgreementId(id);
        companyAgreementDao.create(companyAgreementVo);
        return companyAgreementVo;
    }

}
