package com.pangding.web.authority.dao.company.impl;

import com.pangding.web.authority.dao.company.CompanyTollPointDao;
import com.pangding.web.vo.system.pd.company.CompanyTollPointVo;
import com.pangding.web.vo.system.req.company.CompanyTollPointReqVo;
import com.pangding.web.vo.system.res.company.CompanyTollPointResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

@Component
public class CompanyTollPointDaoImpl extends BaseDaoImpl implements CompanyTollPointDao {

    private final String QUERY_PAGE_LIST = "QUERY_PAGE_LIST";

    @Override
    protected void init() {

        register(CompanyTollPointVo.class);

        table.add(QUERY_PAGE_LIST,"select a.*,b.name as companyName from pd_company_point a left join pd_company b on a.company_id = b.id " +
                "where 1=1{WHERE} ")
                .add("companyId","and a.company_id = ?");

    }

    @Override
    public PageSizeData<CompanyTollPointResVo> queryPageList(CompanyTollPointReqVo req) {
        return this.queryPage(CompanyTollPointResVo.class, req, QUERY_PAGE_LIST, req);
    }

}
