package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CompanyDao;
import com.pangding.web.authority.vo.reqvo.ListCompanyReqVo;
import com.pangding.web.vo.system.pd.company.CompanyVo;
import com.pangding.web.vo.system.req.company.CompanyReqVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.yanzuoguang.dao.DaoConst;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:25
 */
@Component
public class CompanyDaoImpl extends BaseDaoImpl implements CompanyDao {

    private static final String QUERY_COMPANY = "QUERY_COMPANY";

    private static final String QUERY_COMPANY_TOTAL= "QUERY_COMPANY_TOTAL";



    @Override
    protected void init() {

        register(CompanyVo.class);

        table.add(QUERY_COMPANY,"select a.*,b.subledger_status,b.subledger_rule,b.subledger_rule_time,b.divide_status,b.scan_code_pay_status," +
                "invitation_status,invitation_rule_id,invitation_code,invitees_people,invited_people,activation_status,withdraw_rule,min_withdraw_money," +
                "withdraw_fee,withdraw_type,grade,withdraw_total_cash,frozen_money " +
                " from pd_company a inner join pd_company_extend b on a.id = b.id " +
                "where 1=1 {WHERE} order by create_time desc")
                .add("companyName","and company_name LIKE concat('%', ?,'%')  ")
                .add("companyType","and company_type = ? ")
                .add("companyAttribute","and company_attribute = ? ")
                .add("examineStatus","and examine_status = ?")
                .add("companyId","and invitation_company_id = ? ")
                .add("invitationCode","and invitation_code = ? ")
                .add("contactName","and contact_name LIKE concat('%', ?,'%') ")
                .add("contactPhone","and contact_phone = ? ")
                .add("status","and status = ? ")
                .add("startDate","and create_time >= ? ")
                .add("endDate","and create_time <= ? ");

        table.add(QUERY_COMPANY_TOTAL,"select count(a.id) as company_num " +
                " from pd_company a inner join pd_company_extend b on a.id = b.id " +
                "where 1=1 {WHERE} order by create_time desc")
                .add("companyName","and company_name LIKE concat('%', ?,'%')  ")
                .add("companyType","and company_type = ? ")
                .add("companyAttribute","and company_attribute = ? ")
                .add("examineStatus","and examine_status = ?")
                .add("invitationCompanyId","and invitation_company_id = ? ")
                .add("invitationCode","and invitation_code = ? ")
                .add("contactName","and contact_name LIKE concat('%', ?,'%') ")
                .add("contactPhone","and contact_phone = ? ")
                .add("status","and status = ? ")
                .add("startDate","and create_time >= ? ")
                .add("endDate","and create_time <= ? ");

        getSql(DaoConst.LOAD).addCode("{FIELD}", ",b.*", "{INNER}", "INNER JOIN pd_company_extend b ON a.id = b.id");



    }

    @Override
    public PageSizeData<CompanyResVo> getCompanyList(ListCompanyReqVo reqVo) {
        return this.queryPage(CompanyResVo.class,reqVo,QUERY_COMPANY,reqVo);
    }

    @Override
    public CompanyResVo findCompany(CompanyReqVo req) {
        return this.queryFirst(CompanyResVo.class, QUERY_COMPANY, req);
    }

    @Override
    public CompanyResVo findCompanyTotal(CompanyReqVo req) {
        return this.queryFirst(CompanyResVo.class, QUERY_COMPANY, req);
    }
}
