package com.pangding.web.authority.service;


import com.pangding.web.authority.vo.CompanyBankCardVo;
import com.pangding.web.authority.vo.CompanyVo;
import com.pangding.web.authority.vo.UserVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.yanzuoguang.util.vo.PageSizeData;

/**
 * @author Administrator
 */
public interface CompanyService{

    /**
     * 修改公司信息
     * @param companyVo
     */
    void updateCompanyStatus(CompanyVo companyVo);

    /**
     * 分页查询公司信息
     * @param reqVo
     * @return
     */
    PageSizeData<CompanyVo> list(ListCompanyReqVo reqVo);

    /**
     * 查询公司和公司扩展表信息
     * @param reqVo
     * @return
     */
    CompanyResVo getDetail(CompanyGetReqVo reqVo);

    /**
     * 保存公司信息
     * @param reqVo
     */
    String saveCompany(CompanyAndCompanyExtendSaveReqVo reqVo);

    /**
     * 保存银行卡信息，并调用第三方接口发送手机验证码
     *
     * @param reqVo
     * @return
     */
    String saveBank(CompanyBankCardVo reqVo);

    /**
     * 提交银行卡信息，验证手机验证码，并更新银行卡状态
     * @param reqVo
     * @return
     */
    String bankSubmit(BankSubmitReqVo reqVo);

    /**
     * 获取二维码url
     * @param reqVo
     * @return
     */
    String getQrCodeUrl(CompanyExtendGetReqVo reqVo);

    /**
     * 根据二维码源码调用微信接口获取二维码url
     * @param reqVo
     * @return
     */
    String createQrCodeUrl(CreateQrCodeUrlReqVo reqVo);

    /**
     * 获取银行卡列表
     * @param reqVo
     * @return
     */
    PageSizeData<CompanyBankCardVo> getBankCardList(BankCardListReqVo reqVo);

    /**
     * 添加用户
     * @param reqVo
     * @return
     */
    String saveUser(WebUserReqVo reqVo);
}
