package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.CompanyBankCardDao;
import com.pangding.web.authority.dao.CompanyDao;
import com.pangding.web.authority.dao.CompanyExtendDao;
import com.pangding.web.authority.service.CompanyService;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.vo.CompanyBankCardVo;
import com.pangding.web.authority.vo.CompanyExtendVo;
import com.pangding.web.authority.vo.CompanyVo;
import com.pangding.web.authority.vo.UserVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author Administrator
 */
@Service
public class CompanyServiceImpl implements CompanyService{

    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private CompanyExtendDao companyExtendDaoImpl;
    @Autowired
    private CompanyBankCardDao companyBankCardDao;
    @Autowired
    private UserService userServiceImpl;

    /**
     * 修改公司信息
     * @param companyVo
     */
    @Override
    public void updateCompanyStatus(CompanyVo companyVo){
        CompanyVo company = companyDao.load(companyVo.getId(), CompanyVo.class);
        ObjectHelper.writeWithFrom(company, companyVo);
        companyDao.update(company);
    }

    /**
     * 分页查询公司信息
     * @param reqVo
     * @return
     */
    @Override
    public PageSizeData<CompanyVo> list(ListCompanyReqVo reqVo) {
        PageSizeData<CompanyVo> pageSizeData = companyDao.getCompanyList(reqVo);
        if (null == pageSizeData || null == pageSizeData.getList() || pageSizeData.getList().isEmpty()){
            throw new CodeException("暂无公司信息");
        }
        return pageSizeData;
    }

    /**
     * 查询公司和公司扩展表信息
     * @param reqVo
     * @return
     */
    @Override
    public CompanyResVo getDetail(CompanyGetReqVo reqVo) {
        CompanyResVo resVo = new CompanyResVo();
        /*获取公司表信息*/
        CompanyVo companyVo = companyDao.load(reqVo,CompanyVo.class);
        if (null != companyVo){
            resVo.setCompanyVo(companyVo);
        }
        /*获取公司扩展表信息*/
        CompanyExtendGetReqVo companyExtendGetReqVo = new CompanyExtendGetReqVo();
        companyExtendGetReqVo.setId(reqVo.getId());
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(companyExtendGetReqVo,CompanyExtendVo.class);
        if (null != companyExtendVo){
            resVo.setCompanyExtendVo(companyExtendVo);
        }
        /*获取公司银行卡列表*/
        CompanyBankCardGetReqVo companyBankCardGetReqVo = new CompanyBankCardGetReqVo();
        companyBankCardGetReqVo.setCompanyId(reqVo.getId());
        List<CompanyBankCardVo> companyBankCardVoList = companyBankCardDao.loadList(companyBankCardGetReqVo,CompanyBankCardVo.class);
        if (null != companyBankCardVoList || !companyBankCardVoList.isEmpty()){
            resVo.setBankCardVoList(companyBankCardVoList);
        }
        return resVo;
    }

    /**
     * 保存公司信息
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public String saveCompany(CompanyAndCompanyExtendSaveReqVo reqVo) {
        /*若id为空，则新建，若不为空，则更新*/
        if (null == reqVo.getId() || reqVo.getId().isEmpty()){
            reqVo.setId(StringHelper.getNewID());
        }
        /*保存公司表*/
        CompanyVo companyVo = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo,reqVo);
        companyVo.setId(reqVo.getId());
        companyDao.save(companyVo);
        /*保存公司扩展表*/
        CompanyExtendVo companyExtendVo = new CompanyExtendVo();
        ObjectHelper.writeWithFrom(companyExtendVo,reqVo);
        companyExtendVo.setId(reqVo.getId());
        companyExtendDaoImpl.save(companyExtendVo);

        return reqVo.getId();
    }

    /**
     * 保存银行卡信息，并调用第三方接口发送手机验证码
     *
     * @param reqVo
     * @return
     */
    @Override
    public String saveBank(CompanyBankCardVo reqVo) {
        String id = StringHelper.getNewID();
        reqVo.setId(id);
        companyBankCardDao.save(reqVo);
        /*此处需要调用第三方接口发送手机验证码*/
        return id;
    }

    /**
     * 提交银行卡信息，验证手机验证码，并更新银行卡状态
     * @param reqVo
     * @return
     */
    @Override
    public String bankSubmit(BankSubmitReqVo reqVo) {
        /*此处应该将请求数据发送到第三方接口，获取到的返回值用于更新银行卡状态*/
        return reqVo.getVerifyCode();
    }

    /**
     * 获取二维码url
     * @param reqVo
     * @return
     */
    @Override
    public String getQrCodeUrl(CompanyExtendGetReqVo reqVo) {
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(reqVo,CompanyExtendVo.class);
        if (null == companyExtendVo.getQrCodeUrl() || companyExtendVo.getQrCodeUrl().isEmpty()){
            throw new CodeException("未拥有二维码url，请先添加");
        }
        return companyExtendVo.getQrCodeUrl();
    }

    /**
     * 根据二维码源码调用微信接口获取二维码url
     * @param reqVo
     * @return
     */
    @Override
    public String createQrCodeUrl(CreateQrCodeUrlReqVo reqVo) {
        CompanyExtendGetReqVo reqVo1 = new CompanyExtendGetReqVo();
        reqVo1.setId(reqVo.getCompanyId());
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(reqVo1,CompanyExtendVo.class);
        String qrCode = companyExtendVo.getQrCode();
        String select = reqVo.getSelect();
        /*此处应调用微信接口传入qrCode和select获取qrCodeUrl*/
        return null;
    }

    /**
     * 获取银行卡列表分页数据
     * @param reqVo
     * @return
     */
    @Override
    public PageSizeData<CompanyBankCardVo> getBankCardList(BankCardListReqVo reqVo) {
        return companyBankCardDao.getBankCardList(reqVo);
    }

    /**
     * 添加用户
     * @param reqVo
     * @return
     */
    @Override
    public String saveUser(WebUserReqVo reqVo) {
        return userServiceImpl.saveUser(reqVo);
    }
}
