package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.IndexService;
import com.pangding.web.authority.vo.reqvo.*;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/5/27 10:47
 */
@RestController
@RequestMapping(value="/index")
public class IndexController {
    @Autowired
    IndexService indexServiceImpl;

    /**
     * 通过公司id获取该公司的可提现余额
     * @param reqVo 封装了公司id的请求对象
     * @return 可提现的金额
     */
    @PostMapping(value = "/withdrawCash", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<Double> withdrawCash(@RequestBody WithdrawCashReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getId())
                .checkException();
        return ResponseResult.result(indexServiceImpl.getWithdrawCash(reqVo));
    }

    /**
     * 通过公司id获取该公司累积总收益
     * @param reqVo 封装了公司id的请求对象
     * @return 累计总收益
     */
    @PostMapping(value = "/totalIncome", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<BigDecimal> totalIncome(@RequestBody TotalIncomeReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getId())
                .checkException();
        return ResponseResult.result(indexServiceImpl.getTotalIncome(reqVo));
    }

    /**
     * 通过公司id获取该公司的用户沉淀量
     * @param reqVo 封装了公司id的请求对象
     * @return  用户沉淀量
     */
    @PostMapping(value = "/userPrecipitation", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<Integer> userPrecipitation(@RequestBody UserPrecipitationReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getId())
                .checkException();
        return ResponseResult.result(indexServiceImpl.getUserPrecipitation(reqVo));
    }

    /**
     * 通过公司id获取该公司今日实收金额
     * @param reqVo 封装了公司id的请求对象
     * @return  今日实收金额
     */
    @PostMapping(value = "/todayIncome", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult todayIncome(@RequestBody TodayIncomeReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getId())
                .checkException();
        return ResponseResult.result(indexServiceImpl.getTodayIncome(reqVo));
    }

    /**
     * 通过公司id获取该公司的跨界盈利
     * @param reqVo 封装了公司id的请求对象
     * @return  跨界盈利
     */
    @PostMapping(value = "/transboundaryProfit", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult transboundaryProfit(@RequestBody TransboundaryProfitReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getId())
                .checkException();
        return ResponseResult.result(indexServiceImpl.getTransboundaryProfit(reqVo));
    }

    /**
     * 通过公司id获取该公司的用户趋势
     * @param reqVo 封装了公司id的请求对象
     * @return  用户趋势
     */
    @PostMapping(value = "/userTrending", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<List<Long>> userTrending(@RequestBody UserTrendingReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getId())
                .checkException();
        return ResponseResult.result(indexServiceImpl.getUserTrending(reqVo));
    }

    /**
     * 通过公司id获取该公司的资金趋势
     * @param reqVo 封装了公司id的请求对象
     * @return  资金趋势
     */
    @PostMapping(value = "/fundTrending", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult fundTrending(@RequestBody FundTrendingReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getId())
                .checkException();
        return ResponseResult.result(indexServiceImpl.getFundTrending(reqVo));
    }
}
