package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CompanyBankCardDao;
import com.pangding.web.authority.vo.CompanyBankCardVo;
import com.pangding.web.authority.vo.reqvo.BankCardListReqVo;
import com.pangding.web.authority.vo.reqvo.CompanyBankCardSetNotDefaultReqVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

/**
 * @Author zhangjinyao
 * @create 2019/5/16 19:17
 */
@Component
public class CompanyBankCardDaoImpl extends BaseDaoImpl implements CompanyBankCardDao {
    private static final String GET_BANK_CARD_LIST = "GET_BANK_CARD_LIST";
    private static final String SET_NOT_DEFAULT = "SET_NOT_DEFAULT";

    @Override
    protected void init() {
        register(CompanyBankCardVo.class);

        table.add(GET_BANK_CARD_LIST,"select * from pd_company_bank_card where 1=1 ")
                .add("companyId","and company_id = ?");

        table.add(SET_NOT_DEFAULT,"update pd_company_bank_card a set a.is_default = 0 where 1=1 ")
                .add("id","and id = ?")
                .add("companyId","and company_id = ?");
    }

    /**
     * 获取银行卡列表分页数据
     * @param reqVo
     * @return
     */
    @Override
    public PageSizeData<CompanyBankCardVo> getBankCardList(BankCardListReqVo reqVo) {
        return this.queryPage(CompanyBankCardVo.class,reqVo,GET_BANK_CARD_LIST,reqVo);
    }

    @Override
    public void setNotDefault(CompanyBankCardSetNotDefaultReqVo setNotDefaultReqVo) {
        this.updateSql(SET_NOT_DEFAULT,setNotDefaultReqVo);
    }
}
