package com.tcm.system.user.service.impl;

import com.pangding.web.util.RSAUtils;
import com.pangding.web.vo.system.pd.authority.UserVo;
import com.tcm.system.user.dao.UserDao;
import com.tcm.system.user.service.UserService;
import com.tcm.system.user.vo.RsaContant;
import com.tcm.system.user.vo.TcmUserVo;
import com.tcm.system.user.vo.req.TcmUserPageReqVo;
import com.tcm.system.user.vo.req.TcmUserReqVo;
import com.tcm.system.user.vo.req.TcmUserSaveReqVo;
import com.tcm.system.user.vo.res.TcmUserResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class UserServiceImpl implements UserService {

    private UserDao userDao;
    private RsaContant rsaContant;

    public UserServiceImpl(UserDao userDao, RsaContant rsaContant) {
        this.userDao = userDao;
        this.rsaContant = rsaContant;
    }

    @Override
    public TcmUserResVo queryUser(TcmUserReqVo req) {
        return userDao.queryUser(req);
    }

    @Override
    public PageSizeData<TcmUserResVo> findUserPage(TcmUserPageReqVo req){
        return userDao.findUserPage(req);
    }

    @Override
    public List<TcmUserResVo> findUserList(TcmUserReqVo req){
        return userDao.findUserList(req);
    }

    @Override
    public TcmUserResVo findUserInfo(TcmUserReqVo req){
        return userDao.findUserInfo(req);
    }

    @Override
    public String saveUser(TcmUserSaveReqVo req) {
        this.isValid(req.getUsername());
        this.checkAccount(req);
        try{
            /*将RSA加密后的密码解密*/
            String password = RSAUtils.decryptionByPrivateKey(req.getPassword(), rsaContant.getPrivateKey());
            String confirmPassword = RSAUtils.decryptionByPrivateKey(req.getConfirmPassword(), rsaContant.getPrivateKey());
            if (!StringHelper.compare(password, confirmPassword)) {
                throw new CodeException("确认密码错误");
            }
            String md5Password = this.passwordEncoder(password);
            req.setPassword(md5Password);

            TcmUserVo userVo = new TcmUserVo();
            if (StringHelper.isEmpty(req.getUserId())) {
                req.setUserId(StringHelper.getNewID());
                ObjectHelper.writeWithFrom(userVo, req);
                userDao.create(userVo);
            } else {
                ObjectHelper.writeWithFrom(userVo, req);
                userDao.update(userVo);
            }

        }catch (Exception e){
            throw  new CodeException(e.getMessage());
        }
        return req.getUserId();
    }

//    @Override
    public void isValid(String account) {
        String regex = "^(?!\\d+$)[\\da-zA-Z]+$";
        if (!account.matches(regex)) {
            throw new CodeException("错误的用户名：" + account + ",用户名仅支持字母和数字的组合，且不能为纯数字");
        }
    }

//    @Override
    public void checkAccount(TcmUserSaveReqVo userVo) {
        TcmUserSaveReqVo tcmUserSaveReqVo = new TcmUserSaveReqVo();
        tcmUserSaveReqVo.setUsername(userVo.getUsername());
        UserVo userVo1 = userDao.load(tcmUserSaveReqVo, UserVo.class);
        if ((null != userVo1 && null == userVo.getUserId()) ||
                (null != userVo1 && null != userVo.getUserId() && !userVo1.getId().equals(userVo.getUserId()))) {
            throw new CodeException("用户名" + userVo.getUsername() + "已存在");
        }
    }

//    @Override
    public String passwordEncoder(String password) {
        return StringHelper.md5(password);
    }

}
