package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.CompanyMoneyDao;
import com.pangding.web.authority.service.CompanyMoneyService;
import com.pangding.web.vo.system.pd.company.CompanyMoneyVo;
import com.pangding.web.vo.system.req.company.CompanyMoneyReqVo;
import com.pangding.web.vo.system.res.company.CompanyMoneyTotalResVo;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompanyMoneyServiceImpl implements CompanyMoneyService {

    @Autowired
    private CompanyMoneyDao companyMoneyDao;

    /**
     * 找到列表
     * @param req
     * @return
     */
    @Override
    public CompanyMoneyTotalResVo findCompanyMoney(CompanyMoneyReqVo req){
        CompanyMoneyTotalResVo companyMoneyTotalResVo = new CompanyMoneyTotalResVo();

        PageSizeData<CompanyMoneyVo> companyMoneyVoPageSizeData = companyMoneyDao.findCompanyMoneyPage(req);
        companyMoneyTotalResVo.setCompanyMoneyVoPageSizeData(companyMoneyVoPageSizeData);

        CompanyMoneyVo companyMoneyVo = companyMoneyDao.findReport(req);
        companyMoneyTotalResVo.setCompanyMoneyVo(companyMoneyVo);

        if(!StringHelper.isEmpty(req.getCompanyId())){
            CompanyMoneyReqVo companyMoney = new CompanyMoneyReqVo();
            companyMoney.setCompanyId(req.getCompanyId());
            CompanyMoneyVo company = companyMoneyDao.findLastInfo(companyMoney);
            if(!StringHelper.isEmpty(company)){
                companyMoneyTotalResVo.setLastFinalMoney(company.getFinalMoney());
            }
        }else {
            CompanyMoneyReqVo companyMoney = new CompanyMoneyReqVo();
            companyMoney.setCompanyId("10001");
            CompanyMoneyVo company = companyMoneyDao.findLastInfo(companyMoney);
            if(!StringHelper.isEmpty(company)){
                companyMoneyTotalResVo.setLastFinalMoney(company.getFinalMoney());
            }
        }
        return companyMoneyTotalResVo;
    }

    @Override
    public CompanyMoneyVo findLastInfo(CompanyMoneyReqVo req) {
        return companyMoneyDao.findLastInfo(req);
    }


}
