# 参数请符合实体，而不是单独的参数,专注于参数内容，专注于参数顺序
``` java 
{
  id: "1"
}
```
如:
```java 
public List<String> getRoleTrightPKListByRoleId(String roleId) {
    return this.query(String.class,GET_ROLE_TRIGHT_PKLIST_BY_ROLEID,roleId);
}
```


# RoleDaoImpl
## 夏敏的函数请用load，可以删除
``` java 
@Override
public RoleVo getRoleById(String id) {
    return this.queryFirst(RoleVo.class,GET_ROLE_BY_ID,id);
}

@Override
public RoleVo getRoleByName(String name) {
    return this.queryFirst(RoleVo.class,GET_ROLE_BY_NAME,name);
}
```
参见如下代码:
``` java 
dao.load({id:"1"})
dao.load({name:"1"})
```

## 检测语句
``` java 
table.add(CHECK_NAME_EXIST,"select count(r.id) from pd_role r where 1=1 ")
.add("name","and r.name = ? ")
.add("id","and r.id <> ?");
```
改成
```java 
table.addExist(CHECK_NAME_EXIST,"name");
```
调用时
``` java 
this.checkExist(CHECK_NAME_EXIST,roleVo,"橘色名称已经存在");
```

# 请确定语句主表，比如说和 pd_role_authority表和pd_authority表的查询，请另外新建dao层，符合三层架构规范
``` java 

table.add(GET_TRIGHTID_LIST,"select authority_id from pd_role_authority where 1=1 ")
.add("roleId","and role_id = ?");

table.add(GET_TRIGHTNAME_BY_TRIGHTID,"select name from pd_authority where 1=1 ")
.add("trightId","and id = ?");

```

# ＳＱＬ语句合并
```java 
table.add(GET_ROLE_TRIGHT_PKLIST_BY_ROLEID,"select id from pd_role_authority where 1=1 ")
.add("roleId","and role_id = ?");

table.add(GET_ROLE_TRIGHT_PKLIST_BY_TRIGHTID,"select id from pd_role_authority where 1=1 ")
.add("trightId","and tright_id = ?");
```
可以合并为
```java 

table.add(GET_ROLE_TRIGHT_PKLIST_BY_ROLEID,"select id from pd_role_authority where 1=1 ")
.add("roleId","and role_id = ?");
.add("trightId","and tright_id = ?");
```

# 更爱ＳＱＬ语句
```java 
 table.add(CHECK_VALID,"select count(a.id) from pd_authority a where 1=1 ")
        .add("name","and a.name = ? ")
        .add("url","and a.url = ? ")
        .add("id","and a.id <> ?");
```
改为:
``` java 
table.addExist(CHECK_VALID,"name","url");
```

# 将如下ＳＱＬ语句合并
``` java
table.add(GET_TRIGHT_BY_ID,"select * from pd_authority where 1=1 ")
.add("id","and id = ?");

table.add(LIST_ALL,"select * from pd_authority where 1=1");

table.add(LIST_LEVEL_ONE,"select * from pd_authority where pid=null");
// 这句ＳＱＬ语句可以去掉，本身没有意义
table.add(CHECK_CHILD,"select count(id) from pd_authority where 1=1 ")
.add("id","and pid = ?");

table.add(GET_CHILDID_LIST,"select id from pd_authority where 1=1 ")
.add("id","and pid = ?");
```
如:
is null, is not null , ifnull(field,'')=''
```java 
table.add(GET_TRIGHT_BY_ID,"select * from pd_authority where 1=1 ")
.add("id","and id = ?")
.add("top","and ifnull(pid,'')= ''")
.add("pid","and pid = ?");
```

# 将如下ＳＱＬ语句合并
``` java
table.add(GET_USER, "SELECT  id,account,phone,status,remark,create_time,creator FROM pd_user  WHERE 1=1 ")
        .add("account", " AND account = ?");

table.add(GET_ALL_USERS,"select id,account,phone,status,remark,create_time,creator from pd_user where 1=1");

table.add(GET_ROLE_IDS,"select role_id from pd_user_role where 1=1 ")
        .add("userId","and user_id = ?");

table.add(GET_USER_BY_ID,"select id,account,phone,status,remark,create_time,creator from pd_user where 1=1 ")
        .add("userId","and user_id = ?");

table.add(GET_ROLE_BY_ROLEID,"select name from pd_role where 1=1 ")
        .add("roleId","and id = ?");
```

# 如下语句可以删除
``` java
table.add(DELETE_USER_ROLE,"delete from pd_user_role_relation where 1=1 ")
        .add("userId","and user_id = ?");
```
直接调用:
``` 
dao.remove({userId:"1"})
```


# ------------2019-5-19--------------
# 实体中不能引用继承自Date的对象，会存在时区问题 Timestamp,用String配合DateHelper类进行处理

# md5函数已经编写，需要去掉Md5AndSalt类
StringHelper.md5(from)


# 如下代码需要调换顺序
```java 
List<RoleVo> roleVoList = roleServiceImpl.getRoleVoList();
List<RoleDto> roleDtoList = new ArrayList(roleVoList.size());     // roleVoList有可能为null
if (roleVoList == null || roleVoList.size() == 0){
    return new Result(0,"暂无角色信息",null);
}
```

# cloudvo请放到vo中，定义一个cloud的文件夹

# controller命名空间改成web命名空间,controller太长了，并且拦截器拦截的 web....Controller

# currency中的Result实体，需要以vo结尾，并且放入vo，并且自解释太弱，需要把名称补全，如OrderResultVo

# Dto这个命名空间不存在,需要命名的是放在 vo里面，增加res或者req文件夹.并且以 ResVo或者ReqVo结尾，表明是请求信息。
如: 
OrderLoadReqVo,订单加载请求实体
OrderLoadResVo，订单加载输出实体

# GetUserByIdReqVo、GetRoleReqVo等几个实体可以合成为一个
如： UserGetReqVo，该实体具有多个字段
RoleGetReqVo
RoleGetResVo
如果：觉得构造函数复杂，写几个 public static RoleGetReqVo createByRoleId(String roleId);

数据库实体命名规范为: {表名}Vo
实体命名规范为: {表名}{动作}{请求|输出}Vo

# AuthorityController层不能返回Object，请返回ResponseResult
除非你做的是第三方接口
ResponseResult.result()

# Controller层只能检测参数，不能写任何逻辑，逻辑层是Service


# Controller没有参数的函数，不能存在
companyId
